/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.EntityResolver;

@Component
@Singleton
public class LocalEntityResolver
implements EntityResolver {
    @Inject
    private Logger logger;

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = null;
        try {
            URI uri = new URI(systemId);
            if ("http".equals(uri.getScheme()) || "file".equals(uri.getScheme())) {
                String filename = new File(uri.getPath()).getName();
                InputStream istream = this.getClass().getClassLoader().getResourceAsStream(filename);
                if (istream != null) {
                    source = new InputSource(istream);
                } else {
                    this.logger.warn(String.format("Failed to load resource [%s] locally. Will try to get it online at [%s]", filename, systemId));
                }
            } else {
                this.logger.debug(String.format("Unknown URI scheme [%s] for entity [%s]. Assuming the entity is already resolved and looking for it in the file system.", uri.getScheme(), systemId));
                InputStream istream = this.getClass().getClassLoader().getResourceAsStream(systemId);
                if (istream != null) {
                    source = new InputSource(istream);
                } else {
                    this.logger.warn("Failed to load resource [" + systemId + "] locally.");
                }
            }
        }
        catch (URISyntaxException e) {
            this.logger.warn(String.format("Invalid URI [%s]", systemId), (Throwable)e);
        }
        return source;
    }
}

