/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="attribute")
@Singleton
public class AttributeFilter
extends AbstractHTMLFilter {
    private static final Map<String, String> ATTRIBUTE_TO_CSS_PROPERTY = new HashMap<String, String>();
    private static final String VERTICAL_ALIGN = "vertical-align";
    @Inject
    private Logger logger;

    public AttributeFilter() {
        ATTRIBUTE_TO_CSS_PROPERTY.put("align", "text-align");
        ATTRIBUTE_TO_CSS_PROPERTY.put("valign", VERTICAL_ALIGN);
        ATTRIBUTE_TO_CSS_PROPERTY.put("bgcolor", "background-color");
    }

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        StringBuilder xpathExpression = new StringBuilder();
        for (String attributeName : ATTRIBUTE_TO_CSS_PROPERTY.keySet()) {
            if (xpathExpression.length() > 0) {
                xpathExpression.append('|');
            }
            xpathExpression.append("//@").append(attributeName);
        }
        NodeList attributes = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            attributes = (NodeList)xpath.evaluate(xpathExpression.toString(), document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            this.logger.error("Failed to apply the HTML attribute cleaning filter.", (Throwable)e);
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.filterAttribute((Attr)attributes.item(i));
        }
    }

    private void filterAttribute(Attr attribute) {
        StringBuilder style;
        Element element = attribute.getOwnerElement();
        String property = ATTRIBUTE_TO_CSS_PROPERTY.get(attribute.getName());
        String value = attribute.getValue();
        if ("img".equals(element.getTagName()) && "align".equals(attribute.getName())) {
            String string = property = "left".equals(value) || "right".equals(value) ? "float" : VERTICAL_ALIGN;
        }
        if ((style = new StringBuilder(element.getAttribute("style").trim())).length() > 0 && style.charAt(style.length() - 1) != ';') {
            style.append(';');
        }
        style.append(property).append(':').append(value);
        element.setAttribute("style", style.toString());
        element.removeAttributeNode(attribute);
    }
}

