/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.text.StringUtils;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="link")
@Singleton
public class LinkFilter
extends AbstractHTMLFilter {
    private static final String NOOPENER = "noopener";
    private static final String NOREFERRER = "noreferrer";

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        for (Element link : this.filterDescendants(document.getDocumentElement(), new String[]{"a"})) {
            this.filter(link);
        }
    }

    private void filter(Element link) {
        if (!this.isExternalLink(link.getAttribute("href"))) {
            return;
        }
        String target = link.getAttribute("target");
        if (StringUtils.isNotBlank((CharSequence)target) && !"_self".equals(target) && !"_parent".equals(target) && !"_top".equals(target)) {
            ArrayList<String> relAttributes = new ArrayList<String>();
            String relAttribute = link.getAttribute("rel");
            if (relAttribute != null) {
                relAttributes.addAll(Arrays.asList(relAttribute.split(" ")));
            }
            if (!relAttributes.contains(NOOPENER)) {
                relAttributes.add(NOOPENER);
            }
            if (!relAttributes.contains(NOREFERRER)) {
                relAttributes.add(NOREFERRER);
            }
            if (!relAttributes.isEmpty()) {
                link.setAttribute("rel", StringUtils.join(relAttributes, (String)" "));
            }
        }
    }

    private boolean isExternalLink(String href) {
        try {
            URI uri = new URI(href);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

