/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.jira.script;

import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.jira.config.JIRAServer;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="jira")
@Singleton
public class JiraScriptService
implements ScriptService {
    @Inject
    private Logger logger;

    public JiraRestClient getJiraRestClient(JIRAServer jiraServer) {
        return this.getJiraRestClient(jiraServer.getURL(), this.getAuthenticationHandler(jiraServer));
    }

    public ProgressMonitor getNullProgressMonitor() {
        return new NullProgressMonitor();
    }

    private AuthenticationHandler getAuthenticationHandler(JIRAServer jiraServer) {
        Object handler = StringUtils.isBlank((CharSequence)jiraServer.getUsername()) || StringUtils.isBlank((CharSequence)jiraServer.getPassword()) ? new AnonymousAuthenticationHandler() : new BasicHttpAuthenticationHandler(jiraServer.getUsername(), jiraServer.getPassword());
        return handler;
    }

    private JiraRestClient getJiraRestClient(String jiraURL, AuthenticationHandler authenticationHandler) {
        JiraRestClient restClient;
        try {
            JerseyJiraRestClientFactory factory = new JerseyJiraRestClientFactory();
            URI jiraServerUri = new URI(jiraURL);
            restClient = factory.create(jiraServerUri, authenticationHandler);
        }
        catch (URISyntaxException e) {
            this.logger.warn("Invalid JIRA URL [{}]", (Object)jiraURL);
            restClient = null;
        }
        return restClient;
    }
}

