/*
 * Decompiled with CFR 0.152.
 */
package com.cj.jshintmojo;

import com.cj.jshintmojo.cache.Cache;
import com.cj.jshintmojo.cache.Result;
import com.cj.jshintmojo.jshint.FunctionalJava;
import com.cj.jshintmojo.jshint.JSHint;
import com.cj.jshintmojo.reporter.CheckStyleReporter;
import com.cj.jshintmojo.reporter.HTMLReporter;
import com.cj.jshintmojo.reporter.JSHintReporter;
import com.cj.jshintmojo.reporter.JSLintReporter;
import com.cj.jshintmojo.util.OptionsParser;
import com.cj.jshintmojo.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class Mojo
extends AbstractMojo {
    private final List<String> directories = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private String options = null;
    private String globals = "";
    private String configFile = "";
    private String reporter = "";
    private String reportFile = "";
    private String ignoreFile = "";
    private Boolean failOnError = true;
    File basedir;

    public Mojo() {
    }

    public Mojo(String options, String globals, File basedir, List<String> directories, List<String> excludes, boolean failOnError, String configFile, String reporter, String reportFile, String ignoreFile) {
        this.options = options;
        this.globals = globals;
        this.basedir = basedir;
        this.directories.addAll(directories);
        this.excludes.addAll(excludes);
        this.failOnError = failOnError;
        this.configFile = configFile;
        this.reporter = reporter;
        this.reportFile = reportFile;
        this.ignoreFile = ignoreFile;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String version = Mojo.getJSHintVersion();
        this.getLog().info((CharSequence)("using jshint version " + version));
        JSHint jshint = new JSHint(Mojo.getJSHintScript(version));
        Config config = Mojo.readConfig(this.options, this.globals, this.configFile, this.basedir, this.getLog());
        if (this.excludes.isEmpty() || this.ignoreFile != null && !this.ignoreFile.isEmpty()) {
            this.excludes.addAll(Mojo.readIgnore((String)this.ignoreFile, (File)this.basedir, (Log)this.getLog()).lines);
        }
        Cache.Hash cacheHash = new Cache.Hash(config.options, config.globals, version, this.configFile, this.directories, this.excludes);
        if (this.directories.isEmpty()) {
            this.directories.add("src");
        }
        try {
            File targetPath = new File(this.basedir, "target");
            Util.mkdirs(targetPath);
            File cachePath = new File(targetPath, "lint.cache");
            Cache cache = this.readCache(cachePath, cacheHash);
            List<File> files = this.findFilesToCheck();
            Map<String, Result> currentResults = Mojo.lintTheFiles(jshint, cache, files, config, this.getLog());
            Util.writeObject(new Cache(cacheHash, currentResults), cachePath);
            this.handleResults(currentResults, this.reporter, this.reportFile);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Something bad happened", (Exception)e);
        }
    }

    public static String getJSHintScript(String version) {
        return String.format("/META-INF/resources/webjars/jshint/%s/dist/jshint.js", version);
    }

    public static String getJSHintVersion() throws MojoExecutionException {
        try {
            Properties jsHintProperties = new Properties();
            jsHintProperties.load(Mojo.class.getResourceAsStream("/META-INF/maven/org.webjars.npm/jshint/pom.properties"));
            return jsHintProperties.getProperty("version");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to determine the JSHint version in use.", (Exception)e);
        }
    }

    private static Config readConfig(String options, String globals, String configFileParam, File basedir, Log log) throws MojoExecutionException {
        Config config;
        File configFile;
        File jshintRc = Mojo.findJshintrc(basedir);
        File file = configFile = StringUtils.isNotBlank((String)configFileParam) ? new File(basedir, configFileParam) : null;
        if (options == null) {
            if (configFile != null) {
                log.info((CharSequence)("Using configuration file: " + configFile.getAbsolutePath()));
                config = Mojo.processConfigFile(configFile);
            } else if (jshintRc != null) {
                log.info((CharSequence)("Using configuration file: " + jshintRc.getAbsolutePath()));
                config = Mojo.processConfigFile(jshintRc);
            } else {
                config = new Config("", globals);
            }
        } else {
            config = new Config(options, globals);
        }
        return config;
    }

    private static Ignore readIgnore(String ignoreFileParam, File basedir, Log log) throws MojoExecutionException {
        Ignore ignore;
        File ignoreFile;
        File jshintignore = Mojo.findJshintignore(basedir);
        File file = ignoreFile = StringUtils.isNotBlank((String)ignoreFileParam) ? new File(basedir, ignoreFileParam) : null;
        if (ignoreFile != null) {
            log.info((CharSequence)("Using ignore file: " + ignoreFile.getAbsolutePath()));
            ignore = Mojo.processIgnoreFile(ignoreFile);
        } else if (jshintignore != null) {
            log.info((CharSequence)("Using ignore file: " + jshintignore.getAbsolutePath()));
            ignore = Mojo.processIgnoreFile(jshintignore);
        } else {
            ignore = new Ignore(Collections.emptyList());
        }
        return ignore;
    }

    private List<File> findFilesToCheck() {
        ArrayList<File> javascriptFiles = new ArrayList<File>();
        for (String next : this.directories) {
            File path = new File(this.basedir, next);
            if (!path.exists() && !path.isDirectory()) {
                this.getLog().warn((CharSequence)("You told me to find tests in " + next + ", but there is nothing there (" + path.getAbsolutePath() + ")"));
                continue;
            }
            this.collect(path, javascriptFiles);
        }
        List<File> matches = FunctionalJava.filter(javascriptFiles, new FunctionalJava.Fn<File, Boolean>(){

            @Override
            public Boolean apply(File i) {
                for (String exclude : Mojo.this.excludes) {
                    File e = new File(Mojo.this.basedir, exclude);
                    if (!i.getAbsolutePath().startsWith(e.getAbsolutePath())) continue;
                    Mojo.this.getLog().warn((CharSequence)("Excluding " + i));
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return matches;
    }

    private static Map<String, Result> lintTheFiles(JSHint jshint, Cache cache, List<File> filesToCheck, Config config, Log log) throws FileNotFoundException {
        HashMap<String, Result> currentResults = new HashMap<String, Result>();
        for (File file : filesToCheck) {
            Result theResult;
            Result previousResult = cache.previousResults.get(file.getAbsolutePath());
            if (previousResult == null || previousResult.lastModified.longValue() != file.lastModified()) {
                log.info((CharSequence)("  " + file));
                List<JSHint.Error> errors = jshint.run(new FileInputStream(file), config.options, config.globals);
                theResult = new Result(file.getAbsolutePath(), file.lastModified(), errors);
            } else {
                log.info((CharSequence)("  " + file + " [no change]"));
                theResult = previousResult;
            }
            if (theResult == null) continue;
            currentResults.put(theResult.path, theResult);
            Result r = theResult;
            currentResults.put(r.path, r);
            for (JSHint.Error error : r.errors) {
                log.error((CharSequence)("   " + error.line.intValue() + "," + error.character.intValue() + ": " + error.reason));
            }
        }
        return currentResults;
    }

    private void handleResults(Map<String, Result> currentResults, String reporter, String reportFile) throws MojoExecutionException {
        char NEWLINE = '\n';
        StringBuilder errorRecap = new StringBuilder(NEWLINE);
        int numProblematicFiles = 0;
        for (Result r : currentResults.values()) {
            if (r.errors.isEmpty()) continue;
            ++numProblematicFiles;
            errorRecap.append(NEWLINE).append(r.path).append(NEWLINE);
            for (JSHint.Error error : r.errors) {
                errorRecap.append("   ").append(error.line.intValue()).append(",").append(error.character.intValue()).append(": ").append(error.reason).append(NEWLINE);
            }
        }
        if (numProblematicFiles > 0) {
            this.saveReportFile(currentResults, reporter, reportFile);
            String errorMessage = "\nJSHint found problems with " + numProblematicFiles + " file";
            if (numProblematicFiles > 1) {
                errorMessage = errorMessage + "s";
            }
            errorMessage = errorMessage + errorRecap.toString();
            if (this.failOnError.booleanValue()) {
                throw new MojoExecutionException(errorMessage);
            }
            this.getLog().info((CharSequence)errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReportFile(Map<String, Result> results, String reportType, String reportFile) {
        JSHintReporter reporter = null;
        if ("jslint".equalsIgnoreCase(reportType)) {
            reporter = new JSLintReporter();
        } else if ("html".equalsIgnoreCase(reportType)) {
            reporter = new HTMLReporter();
        } else if ("checkstyle".equalsIgnoreCase(reportType)) {
            reporter = new CheckStyleReporter();
        } else {
            if (StringUtils.isNotBlank((String)reportType)) {
                this.getLog().warn((CharSequence)("Unknown reporter \"" + reportType + "\". Skip reporting."));
                return;
            }
            return;
        }
        File file = StringUtils.isNotBlank((String)reportFile) ? new File(reportFile) : new File("target/jshint.xml");
        this.getLog().info((CharSequence)String.format("Generating \"JSHint\" report. reporter=%s, reportFile=%s.", reportType, file.getAbsolutePath()));
        String report = reporter.report(results);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            writer.write(report);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    private static File findJshintrc(File cwd) {
        File placeToLook = cwd;
        while (placeToLook.getParentFile() != null) {
            File rcFile = new File(placeToLook, ".jshintrc");
            if (rcFile.exists()) {
                return rcFile;
            }
            placeToLook = placeToLook.getParentFile();
        }
        return null;
    }

    private static File findJshintignore(File cwd) {
        File placeToLook = cwd;
        while (placeToLook.getParentFile() != null) {
            File ignoreFile = new File(placeToLook, ".jshintignore");
            if (ignoreFile.exists()) {
                return ignoreFile;
            }
            placeToLook = placeToLook.getParentFile();
        }
        return null;
    }

    private Cache readCache(File path, Cache.Hash hash) {
        try {
            if (path.exists()) {
                Cache cache = (Cache)Util.readObject(path);
                if (EqualsBuilder.reflectionEquals((Object)cache.hash, (Object)hash, (String[])new String[0])) {
                    return cache;
                }
                this.getLog().warn((CharSequence)"Something changed ... clearing cache");
                return new Cache(hash);
            }
        }
        catch (Throwable e) {
            super.getLog().warn((CharSequence)"I was unable to read the cache.  This may be because of an upgrade to the plugin.");
        }
        return new Cache(hash);
    }

    private void collect(File directory, List<File> files) {
        for (File next : directory.listFiles()) {
            if (next.isDirectory()) {
                this.collect(next, files);
                continue;
            }
            if (!next.getName().endsWith(".js")) continue;
            files.add(next);
        }
    }

    private static Config processConfigFile(File configFile) throws MojoExecutionException {
        byte[] configFileContents;
        try {
            configFileContents = FileUtils.readFileToByteArray((File)configFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read config file located in " + configFile);
        }
        Set<String> globalsSet = OptionsParser.extractGlobals(configFileContents);
        Set<String> optionsSet = OptionsParser.extractOptions(configFileContents);
        String globals = globalsSet.size() > 0 ? StringUtils.join(globalsSet.iterator(), (String)",") : "";
        String options = optionsSet.size() > 0 ? StringUtils.join(optionsSet.iterator(), (String)",") : "";
        return new Config(options, globals);
    }

    private static Ignore processIgnoreFile(File ignoreFile) throws MojoExecutionException {
        try {
            return new Ignore(FileUtils.readLines((File)ignoreFile, (String)"UTF-8"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read ignore file located in " + ignoreFile, (Exception)e);
        }
    }

    static class Ignore {
        final List<String> lines;

        public Ignore(List<String> lines) {
            this.lines = lines;
        }
    }

    static class Config {
        final String options;
        final String globals;

        public Config(String options, String globals) {
            this.options = options;
            this.globals = globals;
        }
    }
}

