/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.social.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthServiceImpl;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import java.security.GeneralSecurityException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.securityfilter.realm.SimplePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.crypto.passwd.PasswordCryptoService;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.social.authentication.SocialAuthConstants;
import org.xwiki.social.authentication.SocialAuthException;
import org.xwiki.social.authentication.SocialAuthSession;
import org.xwiki.social.authentication.SocialAuthenticationManager;

public class SocialAuthServiceImpl
extends XWikiAuthServiceImpl
implements SocialAuthConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocialAuthServiceImpl.class);

    public Principal authenticate(String login, String password, XWikiContext context) throws XWikiException {
        LOGGER.debug("Social login authenticate...");
        XWikiRequest request = context.getRequest();
        HttpSession httpSession = request.getSession();
        SocialAuthenticationManager manager = (SocialAuthenticationManager)Utils.getComponent(SocialAuthenticationManager.class);
        if (StringUtils.isBlank((CharSequence)request.getParameter("sl_provider")) && !manager.isConnected()) {
            LOGGER.debug("No provider given: let XWiki authenticate...");
            return super.authenticate(login, password, context);
        }
        SocialAuthSession session = manager.getSession();
        String provider = (String)StringUtils.defaultIfBlank((CharSequence)(session != null ? session.getCurrentProvider() : null), (CharSequence)request.getParameter("sl_provider"));
        try {
            if (!manager.isConnected(provider) || password == null) {
                this.trySocialAuthConnect(provider, manager, context);
                return null;
            }
            return this.validateCredentials(login, password, session, manager, context);
        }
        catch (Exception e) {
            LOGGER.error("Error while Social login authentication", (Throwable)e);
            return null;
        }
    }

    private void trySocialAuthConnect(String provider, SocialAuthenticationManager manager, XWikiContext context) throws SocialAuthException, XWikiException {
        XWikiRequest request = context.getRequest();
        if (StringUtils.isBlank((CharSequence)request.getParameter("sl_callback")) && manager.getSession() == null) {
            String url = request.getRequestURL() + "?" + "sl_callback" + "=1&" + "sl_provider" + "=" + provider;
            manager.requestConnection(provider, url);
        } else {
            DocumentReference user;
            if (manager.getSession() == null || manager.getSession().getProfile() == null) {
                LOGGER.debug("We back from OAuth URL");
                user = manager.connect(SocialAuthUtil.getRequestParametersMap((HttpServletRequest)request));
            } else {
                user = manager.getUser(provider, manager.getSession().getProfile().getValidatedId());
                LOGGER.debug("Already a profile in the session. User " + user);
            }
            if (user != null) {
                XWikiDocument document = context.getWiki().getDocument(user, context);
                BaseObject profileObject = document.getObject("XWiki.SocialLoginProfileClass", "provider", provider);
                String passwd = profileObject.getStringValue("password");
                this.checkAuth(document.getName(), passwd, "true", context);
            }
        }
    }

    private Principal validateCredentials(String username, String password, SocialAuthSession session, SocialAuthenticationManager manager, XWikiContext context) throws GeneralSecurityException, XWikiException {
        LOGGER.debug("Found a social profile in session");
        PasswordCryptoService passwordCryptoService = (PasswordCryptoService)Utils.getComponent(PasswordCryptoService.class);
        String key = context.getWiki().Param("xwiki.authentication.encryptionKey");
        DocumentReference user = manager.getUser(session.getProfile().getProviderId(), session.getProfile().getValidatedId());
        XWikiDocument document = context.getWiki().getDocument(user, context);
        if (!StringUtils.isBlank((CharSequence)session.getEncryptedPassword()) && passwordCryptoService.decryptText(session.getEncryptedPassword(), key).equals(password) && username.equals(document.getName())) {
            LOGGER.debug("Password match, returning principal " + document.getName());
            return new SimplePrincipal(document.getPrefixedFullName());
        }
        LOGGER.debug("Password null or password mismatch");
        if (!StringUtils.isBlank((CharSequence)password)) {
            LOGGER.debug("Password null");
            context.getRequest().getSession().removeAttribute("org.xwiki.social.authentication.SocialAuthSession");
        }
        return super.authenticate(username, password, context);
    }
}

