/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.enterprise.migrator.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionScriptService;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Named(value="distribution")
@Singleton
public class Migrator
extends DistributionScriptService {
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private static Logger logger;

    public ExtensionId getUIExtensionId(String wiki) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext.isMainWiki(wiki)) {
            return this.distributionManager.getMainUIExtensionId();
        }
        try {
            DocumentReference wikiDocumentRef = this.documentReferenceResolver.resolve((Object)(xcontext.getMainXWiki() + ":" + XWiki.getServerWikiPage((String)wiki)), new Object[0]);
            XWikiDocument wikiDocument = xcontext.getWiki().getDocument(wikiDocumentRef, xcontext);
            DocumentReference workspaceClassRef = new DocumentReference(xcontext.getMainXWiki(), "WorkspaceManager", "WorkspaceClass");
            if (wikiDocument.getXObject(workspaceClassRef) != null) {
                CoreExtension distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
                Model mavenModel = (Model)distributionExtension.getProperty("maven.Model");
                String wikiUIId = mavenModel.getProperties().getProperty("xwiki.extension.distribution.workspaceui");
                return new ExtensionId(wikiUIId, distributionExtension.getId().getVersion());
            }
        }
        catch (XWikiException e) {
            logger.error("Failed to get wiki descriptor for wiki [{}]", (Object)wiki, (Object)e);
        }
        return this.distributionManager.getWikiUIExtensionId();
    }
}

