/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.cluster;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.test.cluster.framework.AbstractClusterHttpTest;

public class DocumentCacheTest
extends AbstractClusterHttpTest {
    @Test
    public void testDocumentCacheSync() throws Exception {
        String result;
        this.switchXWiki(0);
        this.setPageContent(this.getWiki(), "Test", "CacheSync", "content");
        Assert.assertEquals((Object)"content", (Object)this.getPageContent(this.getWiki(), "Test", "CacheSync"));
        this.switchXWiki(1);
        this.setPageContent(this.getWiki(), "Test", "CacheSync", "modified content");
        Assert.assertEquals((Object)"modified content", (Object)this.getPageContent(this.getWiki(), "Test", "CacheSync"));
        this.switchXWiki(0);
        long t1 = System.currentTimeMillis();
        while (!(result = this.getPageContent(this.getWiki(), "Test", "CacheSync")).equalsIgnoreCase("modified content")) {
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 10000L) {
                Assert.fail((String)("Content should have been [modified content] but was [" + result + "]"));
            }
            Thread.sleep(100L);
        }
    }

    @Test
    public void testDocumentCacheSyncForAttachments() throws Exception {
        this.switchXWiki(0);
        this.setPageContent(this.getWiki(), "Test", "AttachementCacheSync", "content");
        this.switchXWiki(1);
        String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Test", "AttachementCacheSync", "file.ext"}).toString();
        PutMethod putMethod = this.executePut(attachmentUri, "content", "text/plain", "Admin", "admin");
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
        this.switchXWiki(0);
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Test", "AttachementCacheSync"}).toString();
        long t1 = System.currentTimeMillis();
        while (!this.hasAttachment(attachmentsUri)) {
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 10000L) {
                Assert.fail((String)"Failed to find attachment");
            }
            Thread.sleep(100L);
        }
    }

    private boolean hasAttachment(String attachmentsUri) throws Exception {
        GetMethod getMethod = this.executeGet(attachmentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        boolean found = false;
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (Attachment attachment : attachments.getAttachments()) {
            System.out.println(attachment.getName());
            if (!attachment.getName().equals("file.ext")) continue;
            found = true;
            break;
        }
        return found;
    }
}

