/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.escaping.framework;

import java.util.List;
import org.xwiki.validator.ValidationError;

public class EscapingError
extends AssertionError {
    private static final long serialVersionUID = 7784831403359592333L;

    public EscapingError(String message) {
        super((Object)message);
    }

    public EscapingError(Throwable cause) {
        super((Object)cause);
    }

    public EscapingError(String message, String fileName, String url, List<ValidationError> errors) {
        super((Object)EscapingError.formatMessage(message, fileName, url, errors));
    }

    public EscapingError(String message, List<EscapingError> errors) {
        super((Object)EscapingError.formatMessageList(message, errors));
    }

    public static final String formatMessage(String message, String fileName, String url, List<ValidationError> errors) {
        StringBuilder result = new StringBuilder(message == null ? "" : message);
        result.append("\n  Tested file: ").append(fileName);
        result.append("\n  URL: ").append(url);
        if (errors == null || errors.size() == 0) {
            result.append('\n');
            return result.toString();
        }
        StringBuilder fatalBuilder = new StringBuilder();
        StringBuilder errorBuilder = new StringBuilder();
        StringBuilder warningBuilder = new StringBuilder();
        String format = "\n    line %4d  column %3d  %s";
        block5: for (ValidationError error : errors) {
            String str = String.format("\n    line %4d  column %3d  %s", error.getLine(), error.getColumn(), error.toString());
            switch (error.getType()) {
                case FATAL: {
                    fatalBuilder.append(str);
                    continue block5;
                }
                case ERROR: {
                    errorBuilder.append(str);
                    continue block5;
                }
                case WARNING: {
                    warningBuilder.append(str);
                    continue block5;
                }
            }
            throw new RuntimeException("Should not happen: Error type = " + error.getType());
        }
        result.append("\n  List of validation errors:");
        result.append((CharSequence)fatalBuilder);
        result.append((CharSequence)errorBuilder);
        result.append((CharSequence)warningBuilder);
        result.append('\n');
        return result.toString();
    }

    public static String formatMessageList(String message, List<EscapingError> errors) {
        StringBuilder result = new StringBuilder(message == null ? "" : message + "\n");
        for (EscapingError error : errors) {
            result.append(error.getMessage());
        }
        return result.toString();
    }
}

