/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.po.xe;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.appwithinminutes.test.po.EntryEditPage;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.ClassEditPage;

public class ClassSheetPage
extends ViewPage {
    @FindBy(partialLinkText="View the template document")
    private WebElement templateLink;
    @FindBy(partialLinkText="View the sheet document")
    private WebElement sheetLink;
    @FindBy(xpath="//*[contains(@class, 'warningmessage')]//a[. = 'class editor']")
    private WebElement defineClassLink;
    @FindBy(linkText="add or modify the class properties")
    private WebElement editClassLink;
    @FindBy(xpath="//input[@class = 'button' and @value = 'Create the document sheet']")
    private WebElement createSheetButton;
    @FindBy(xpath="//*[contains(@class, 'warningmessage')]//a[. = 'Bind the sheet to the class \u00bb']")
    private WebElement bindSheetLink;
    @FindBy(xpath="//input[@class = 'button' and @value = 'Create the document template']")
    private WebElement createTemplateButton;
    @FindBy(xpath="//*[contains(@class, 'warningmessage')]//a[contains(., ' object to the template \u00bb')]")
    private WebElement addObjectToTemplateLink;
    @FindBy(id="spaceName")
    private WebElement spaceNameInput;
    @FindBy(id="docName")
    private WebElement documentNameInput;
    @FindBy(xpath="//input[@class = 'button' and @value = 'Create this document']")
    private WebElement createDocumentButton;

    public ViewPage clickTemplateLink() {
        this.templateLink.click();
        return new ViewPage();
    }

    public ViewPage clickSheetLink() {
        this.sheetLink.click();
        return new ViewPage();
    }

    public ClassEditPage clickDefineClassLink() {
        this.defineClassLink.click();
        return new ClassEditPage();
    }

    public ClassEditPage clickEditClassLink() {
        this.editClassLink.click();
        return new ClassEditPage();
    }

    public boolean hasProperty(String name, String prettyName, String type) {
        String xpath = String.format("//li[. = '%s (%s: %s)']", prettyName, name, type);
        return ClassSheetPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)xpath)).size() == 1;
    }

    public ClassSheetPage clickCreateSheetButton() {
        this.createSheetButton.click();
        return new ClassSheetPage();
    }

    public ClassSheetPage clickBindSheetLink() {
        this.bindSheetLink.click();
        return new ClassSheetPage();
    }

    public ClassSheetPage clickCreateTemplateButton() {
        this.createTemplateButton.click();
        return new ClassSheetPage();
    }

    public ClassSheetPage clickAddObjectToTemplateLink() {
        this.addObjectToTemplateLink.click();
        return new ClassSheetPage();
    }

    public WebElement getSpaceNameInput() {
        return this.spaceNameInput;
    }

    public WebElement getDocumentNameInput() {
        return this.documentNameInput;
    }

    public EntryEditPage clickCreateDocumentButton() {
        this.createDocumentButton.click();
        return new EntryEditPage();
    }

    public EntryEditPage createNewDocument(String spaceName, String pageName) {
        this.spaceNameInput.clear();
        this.spaceNameInput.sendKeys(new CharSequence[]{spaceName});
        this.documentNameInput.clear();
        this.documentNameInput.sendKeys(new CharSequence[]{pageName});
        return this.clickCreateDocumentButton();
    }

    public boolean hasDocument(String documentName) {
        String xpath = String.format("//li//a[. = '%s']", documentName);
        return ClassSheetPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)xpath)).size() == 1;
    }

    public ClassSheetPage waitUntilPageIsLoaded() {
        this.waitUntilElementIsVisible(By.id((String)"HTheclasstemplate"));
        return this;
    }
}

