/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.po.xe;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.po.xe.ClassSheetPage;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.WikiEditPage;

public class DataTypesPage
extends ViewPage {
    @FindBy(id="space")
    private WebElement spaceNameInput;
    @FindBy(id="name")
    private WebElement classNameInput;
    @FindBy(xpath="//*[@class = 'button' and @value = 'Create this Class']")
    private WebElement createClassButton;

    public static DataTypesPage gotoPage() {
        DataTypesPage.getUtil().gotoPage("XWiki", "XWikiClasses");
        return new DataTypesPage();
    }

    public ClassSheetPage createClass(String spaceName, String className) {
        this.spaceNameInput.clear();
        this.spaceNameInput.sendKeys(new CharSequence[]{spaceName});
        this.classNameInput.clear();
        this.classNameInput.sendKeys(new CharSequence[]{className});
        this.createClassButton.click();
        new WikiEditPage().clickSaveAndView();
        return new ClassSheetPage();
    }

    public WebElement getSpaceNameInput() {
        return this.spaceNameInput;
    }

    public WebElement getClassNameInput() {
        return this.classNameInput;
    }

    public WebElement getCreateClassButton() {
        return this.createClassButton;
    }

    public boolean isClassListed(String spaceName, String className) {
        String xpath = String.format("//dd//a[. = '%s' and contains(@href, '/%s/')]", className, spaceName);
        return DataTypesPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)xpath)).size() == 1;
    }
}

