/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.util.URIUtil;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.resources.attachments.AttachmentHistoryResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsAtPageVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;
import org.xwiki.test.ui.TestUtils;

public class AttachmentsResourceTest
extends AbstractHttpTest {
    private final String SPACE_NAME = "Main";
    private final String PAGE_NAME = "WebHome";

    @Override
    @Test
    public void testRepresentation() throws Exception {
    }

    @Test
    public void testPUTAttachment() throws Exception {
        String randomStr = String.format("%s.txt", UUID.randomUUID());
        this.putAttachmentFilename(randomStr, "random");
        this.putAttachmentFilename("my attach.txt", "space");
        this.putAttachmentFilename("^caret.txt", "caret");
        this.putAttachmentFilename("#pound.txt", "pound");
        this.putAttachmentFilename("%percent.txt", "percent");
        this.putAttachmentFilename("{brace}.txt", "braces");
        this.putAttachmentFilename("[bracket].txt", "brackets");
        this.putAttachmentFilename("plus+plus.txt", "plus");
    }

    protected void putAttachmentFilename(String attachmentName, String type) throws Exception {
        String content = "ATTACHMENT CONTENT";
        String attachmentURI = this.buildAttachmentURI(attachmentName);
        GetMethod getMethod = this.executeGet(attachmentURI);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
        PutMethod putMethod = this.executePut(attachmentURI, content, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
        getMethod = this.executeGet(attachmentURI);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Assert.assertEquals((Object)content, (Object)getMethod.getResponseBodyAsString());
    }

    @Test
    public void testPUTAttachmentNoRights() throws Exception {
        String attachmentName = String.format("%s.txt", UUID.randomUUID());
        String attachmentURI = this.buildAttachmentURI(attachmentName);
        String content = "ATTACHMENT CONTENT";
        GetMethod getMethod = this.executeGet(attachmentURI);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
        PutMethod putMethod = this.executePut(attachmentURI, content, "text/plain");
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)401L, (long)putMethod.getStatusCode());
    }

    @Test
    public void testGETAttachments() throws Exception {
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((attachments.getAttachments().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDELETEAttachment() throws Exception {
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((attachments.getAttachments().size() > 0 ? 1 : 0) != 0);
        String attachmentName = ((Attachment)attachments.getAttachments().get(0)).getName();
        String attachmentURI = this.buildAttachmentURI(attachmentName);
        DeleteMethod deleteMethod = this.executeDelete(attachmentURI, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (long)204L, (long)deleteMethod.getStatusCode());
        getMethod = this.executeGet(attachmentURI);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testDELETEAttachmentNoRights() throws Exception {
        String attachmentName = String.format("%d.txt", System.currentTimeMillis());
        String attachmentURI = this.buildAttachmentURI(attachmentName);
        String content = "ATTACHMENT CONTENT";
        PutMethod putMethod = this.executePut(attachmentURI, content, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
        DeleteMethod deleteMethod = this.executeDelete(attachmentURI);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (long)401L, (long)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(attachmentURI);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testGETAttachmentsAtPageVersion() throws Exception {
        int i;
        int NUMBER_OF_ATTACHMENTS = 4;
        String[] attachmentNames = new String[4];
        String[] pageVersions = new String[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            attachmentNames[i2] = String.format("%s.txt", UUID.randomUUID());
        }
        String content = "ATTACHMENT CONTENT";
        for (i = 0; i < 4; ++i) {
            String attachmentURI = this.buildAttachmentURI(attachmentNames[i]);
            PutMethod putMethod = this.executePut(attachmentURI, content, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
            Attachment attachment = (Attachment)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
            pageVersions[i] = attachment.getPageVersion();
        }
        for (i = 0; i < 4; ++i) {
            String attachmentsUri = this.getUriBuilder(AttachmentsAtPageVersionResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", pageVersions[i]}).toString();
            GetMethod getMethod = this.executeGet(attachmentsUri);
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            for (int j = 0; j <= i; ++j) {
                boolean found = false;
                for (Attachment attachment : attachments.getAttachments()) {
                    if (!attachment.getName().equals(attachmentNames[j]) || !attachment.getPageVersion().equals(pageVersions[i])) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((String)String.format("%s is not present in attachments list of the page at version %s", attachmentNames[j], pageVersions[i]), (boolean)found);
            }
            for (Attachment attachment : attachments.getAttachments()) {
                this.checkLinks((LinkCollection)attachment);
            }
        }
    }

    @Test
    public void testGETAttachmentVersions() throws Exception {
        int NUMBER_OF_VERSIONS = 4;
        String attachmentName = String.format("%s.txt", UUID.randomUUID().toString());
        HashMap<String, String> versionToContentMap = new HashMap<String, String>();
        for (int i = 0; i < 4; ++i) {
            String attachmentURI = this.buildAttachmentURI(attachmentName);
            String content = String.format("CONTENT %d", i);
            PutMethod putMethod = this.executePut(attachmentURI, content, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
            if (i == 0) {
                Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
            } else {
                Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
            }
            Attachment attachment = (Attachment)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
            versionToContentMap.put(attachment.getVersion(), content);
        }
        String attachmentsUri = this.getUriBuilder(AttachmentHistoryResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (Attachment attachment : attachments.getAttachments()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)attachment, "http://www.xwiki.org/rel/attachmentData").getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Assert.assertEquals(versionToContentMap.get(attachment.getVersion()), (Object)getMethod.getResponseBodyAsString());
        }
    }

    @Test
    public void testPOSTAttachment() throws Exception {
        String attachmentName = String.format("%s.txt", UUID.randomUUID());
        String content = "ATTACHMENT CONTENT";
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword()));
        httpClient.getParams().setAuthenticationPreemptive(true);
        Part[] parts = new Part[1];
        ByteArrayPartSource baps = new ByteArrayPartSource(attachmentName, "ATTACHMENT CONTENT".getBytes());
        parts[0] = new FilePart(attachmentName, (PartSource)baps);
        PostMethod postMethod = new PostMethod(attachmentsUri);
        MultipartRequestEntity mpre = new MultipartRequestEntity(parts, postMethod.getParams());
        postMethod.setRequestEntity((RequestEntity)mpre);
        httpClient.executeMethod((HttpMethod)postMethod);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        Header location = postMethod.getResponseHeader("location");
        GetMethod getMethod = this.executeGet(location.getValue());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Assert.assertEquals((Object)"ATTACHMENT CONTENT", (Object)getMethod.getResponseBodyAsString());
    }

    private String buildAttachmentURI(String attachmentName) throws Exception {
        String encodedAttachmentName = URIUtil.encodePath((String)attachmentName);
        String encodedPageName = URIUtil.encodePath((String)"WebHome");
        String encodedSpaceName = URIUtil.encodePath((String)"Main");
        return this.getUriBuilder(AttachmentResource.class).buildFromEncoded(new Object[]{this.getWiki(), encodedSpaceName, encodedPageName, encodedAttachmentName}).toString();
    }
}

