/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;
import org.xwiki.test.ui.TestUtils;

public class ObjectsResourceTest
extends AbstractHttpTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        if (link == null) {
            Object object = this.objectFactory.createObject();
            object.setClassName("XWiki.TagClass");
            PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        }
    }

    @Override
    @Test
    public void testRepresentation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        Assert.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            getMethod = this.executeGet(link.getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            this.checkLinks((LinkCollection)objectSummary);
            for (Property property : object.getProperties()) {
                this.checkLinks((LinkCollection)property);
            }
        }
    }

    @Test
    public void testGETNotExistingObject() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", "NOTEXISTING", 0}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
    }

    public Property getProperty(Object object, String propertyName) {
        for (Property property : object.getProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    @Test
    public void testPOSTObject() throws Exception {
        String TAG_VALUE = "TAG";
        Property property = new Property();
        property.setName("tags");
        property.setValue("TAG");
        Object object = this.objectFactory.createObject();
        object.setClassName("XWiki.TagClass");
        object.getProperties().add(property);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)"TAG", (java.lang.Object)this.getProperty(object, "tags").getValue());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", object.getClassName(), object.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)"TAG", (java.lang.Object)this.getProperty(object, "tags").getValue());
    }

    @Test
    public void testPOSTInvalidObject() throws Exception {
        String TAG_VALUE = "TAG";
        Property property = new Property();
        property.setName("tags");
        property.setValue("TAG");
        Object object = this.objectFactory.createObject();
        object.getProperties().add(property);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)400L, (long)postMethod.getStatusCode());
    }

    @Test
    public void testPOSTObjectNotAuthorized() throws Exception {
        String TAG_VALUE = "TAG";
        Property property = new Property();
        property.setName("tags");
        property.setValue("TAG");
        Object object = this.objectFactory.createObject();
        object.setClassName("XWiki.TagClass");
        object.getProperties().add(property);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)401L, (long)postMethod.getStatusCode());
    }

    @Test
    public void testPUTObject() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        Object objectToBePut = this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Object objectSummary = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        this.getProperty(objectSummary, "tags").setValue(TAG_VALUE);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString(), objectSummary, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        Object updatedObjectSummary = (Object)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)TAG_VALUE, (java.lang.Object)this.getProperty(updatedObjectSummary, "tags").getValue());
        Assert.assertEquals((java.lang.Object)objectSummary.getClassName(), (java.lang.Object)updatedObjectSummary.getClassName());
        Assert.assertEquals((long)objectSummary.getNumber(), (long)updatedObjectSummary.getNumber());
    }

    @Test
    public void testPUTObjectUnauthorized() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        Object objectToBePut = this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        String originalTagValue = this.getProperty(object, "tags").getValue();
        this.getProperty(object, "tags").setValue(TAG_VALUE);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString(), object);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)401L, (long)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)originalTagValue, (java.lang.Object)this.getProperty(object, "tags").getValue());
    }

    @Test
    public void testDELETEObject() throws Exception {
        Object objectToBeDeleted = this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString(), TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (long)204L, (long)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testDELETEObjectUnAuthorized() throws Exception {
        Object objectToBeDeleted = this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (long)401L, (long)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testPUTProperty() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        Assert.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        Object currentObject = null;
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals("XWiki.TagClass")) continue;
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            Assert.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            break;
        }
        Assert.assertNotNull(currentObject);
        Property tagsProperty = this.getProperty(currentObject, "tags");
        Assert.assertNotNull((java.lang.Object)tagsProperty);
        Link tagsPropertyLink = this.getFirstLinkByRelation((LinkCollection)tagsProperty, "self");
        Assert.assertNotNull((java.lang.Object)tagsPropertyLink);
        Property newTags = this.objectFactory.createProperty();
        newTags.setValue(TAG_VALUE);
        PutMethod putMethod = this.executePutXml(tagsPropertyLink.getHref(), newTags, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", currentObject.getClassName(), currentObject.getNumber()}).toString());
        Assert.assertEquals((long)200L, (long)getMethod.getStatusCode());
        currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        tagsProperty = this.getProperty(currentObject, "tags");
        Assert.assertEquals((java.lang.Object)TAG_VALUE, (java.lang.Object)tagsProperty.getValue());
    }

    @Test
    public void testPUTPropertyWithTextPlain() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        Assert.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        Object currentObject = null;
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals("XWiki.TagClass")) continue;
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            Assert.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            break;
        }
        Assert.assertNotNull(currentObject);
        Property tagsProperty = this.getProperty(currentObject, "tags");
        Assert.assertNotNull((java.lang.Object)tagsProperty);
        Link tagsPropertyLink = this.getFirstLinkByRelation((LinkCollection)tagsProperty, "self");
        Assert.assertNotNull((java.lang.Object)tagsPropertyLink);
        PutMethod putMethod = this.executePut(tagsPropertyLink.getHref(), TAG_VALUE, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", currentObject.getClassName(), currentObject.getNumber()}).toString());
        Assert.assertEquals((long)200L, (long)getMethod.getStatusCode());
        currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        tagsProperty = this.getProperty(currentObject, "tags");
        Assert.assertEquals((java.lang.Object)TAG_VALUE, (java.lang.Object)tagsProperty.getValue());
    }

    private Object createObjectIfDoesNotExists(String className, String spaceName, String pageName) throws Exception {
        this.createPageIfDoesntExist(spaceName, pageName, "");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), spaceName, pageName}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals(className)) continue;
            Link link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            Assert.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            return object;
        }
        Object object = this.objectFactory.createObject();
        object.setClassName(className);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), spaceName, pageName}).toString(), object, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        return object;
    }

    @Test
    public void testPUTObjectFormUrlEncoded() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        Object objectToBePut = this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("property#tags", TAG_VALUE)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString()), nameValuePairs, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)202L, (long)postMethod.getStatusCode());
        Object updatedObjectSummary = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)TAG_VALUE, (java.lang.Object)this.getProperty(updatedObjectSummary, "tags").getValue());
        Assert.assertEquals((java.lang.Object)object.getClassName(), (java.lang.Object)updatedObjectSummary.getClassName());
        Assert.assertEquals((long)object.getNumber(), (long)updatedObjectSummary.getNumber());
    }

    @Test
    public void testPOSTObjectFormUrlEncoded() throws Exception {
        String TAG_VALUE = "TAG";
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("className", "XWiki.TagClass"), new NameValuePair("property#tags", "TAG")};
        PostMethod postMethod = this.executePostForm(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), nameValuePairs, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        Object object = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)"TAG", (java.lang.Object)this.getProperty(object, "tags").getValue());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", object.getClassName(), object.getNumber()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((java.lang.Object)"TAG", (java.lang.Object)this.getProperty(object, "tags").getValue());
    }

    @Test
    public void testPUTPropertyFormUrlEncoded() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        Assert.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        Object currentObject = null;
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals("XWiki.TagClass")) continue;
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            Assert.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            break;
        }
        Assert.assertNotNull(currentObject);
        Property tagsProperty = this.getProperty(currentObject, "tags");
        Assert.assertNotNull((java.lang.Object)tagsProperty);
        Link tagsPropertyLink = this.getFirstLinkByRelation((LinkCollection)tagsProperty, "self");
        Assert.assertNotNull((java.lang.Object)tagsPropertyLink);
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("property#tags", TAG_VALUE)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", tagsPropertyLink.getHref()), nameValuePairs, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)202L, (long)postMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", currentObject.getClassName(), currentObject.getNumber()}).toString());
        Assert.assertEquals((long)200L, (long)getMethod.getStatusCode());
        currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        tagsProperty = this.getProperty(currentObject, "tags");
        Assert.assertEquals((java.lang.Object)TAG_VALUE, (java.lang.Object)tagsProperty.getValue());
    }

    @Test
    public void testGETObjectAtPageVersion() throws Exception {
        Object objectToBePut = this.createObjectIfDoesNotExists("XWiki.TagClass", "Main", "WebHome");
        HashMap<String, String> versionToValueMap = new HashMap<String, String>();
        for (int i = 0; i < 5; ++i) {
            String value = String.format("Value%d", i);
            Property property = this.getProperty(objectToBePut, "tags");
            property.setValue(value);
            PutMethod putMethod = this.executePutXml(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString(), objectToBePut, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
            GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            versionToValueMap.put(page.getVersion(), value);
        }
        for (String version : versionToValueMap.keySet()) {
            GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectAtPageVersionResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", version, objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Object currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            Property property = this.getProperty(currentObject, "tags");
            Assert.assertEquals(versionToValueMap.get(version), (java.lang.Object)property.getValue());
            this.checkLinks((LinkCollection)currentObject);
            for (Property p : currentObject.getProperties()) {
                this.checkLinks((LinkCollection)p);
            }
        }
    }
}

