/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.Locale;
import java.util.UUID;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Spaces;
import org.xwiki.rest.model.jaxb.Syntaxes;
import org.xwiki.rest.model.jaxb.Translation;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.pages.PageChildrenResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;
import org.xwiki.test.ui.TestUtils;

public class PageResourceTest
extends AbstractHttpTest {
    private Page getFirstPage() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        Wiki wiki = (Wiki)wikis.getWikis().get(0);
        Link spacesLink = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/spaces");
        Assert.assertNotNull((Object)spacesLink);
        getMethod = this.executeGet(spacesLink.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Spaces spaces = (Spaces)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((spaces.getSpaces().size() > 0 ? 1 : 0) != 0);
        Space space = null;
        for (Space s : spaces.getSpaces()) {
            if (!"Main".equals(s.getName())) continue;
            space = s;
            break;
        }
        Link pagesInSpace = this.getFirstLinkByRelation((LinkCollection)space, "http://www.xwiki.org/rel/pages");
        Assert.assertNotNull((Object)pagesInSpace);
        getMethod = this.executeGet(pagesInSpace.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((pages.getPageSummaries().size() > 0 ? 1 : 0) != 0);
        Link pageLink = null;
        for (PageSummary ps : pages.getPageSummaries()) {
            if (!"WebHome".equals(ps.getName())) continue;
            pageLink = this.getFirstLinkByRelation((LinkCollection)ps, "http://www.xwiki.org/rel/page");
            Assert.assertNotNull((Object)pageLink);
            break;
        }
        Assert.assertNotNull(pageLink);
        getMethod = this.executeGet(pageLink.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        return page;
    }

    @Override
    @Test
    public void testRepresentation() throws Exception {
        Page page = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "self");
        Assert.assertNotNull((Object)link);
        this.checkLinks((LinkCollection)page);
    }

    @Test
    public void testGETNotExistingPage() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "NOTEXISTING", "NOTEXISTING"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testPUTGETPage() throws Exception {
        String title = String.format("Title (%s)", UUID.randomUUID().toString());
        String content = String.format("This is a content (%d)", System.currentTimeMillis());
        String comment = String.format("Updated title and content (%d)", System.currentTimeMillis());
        Page originalPage = this.getFirstPage();
        Page newPage = this.objectFactory.createPage();
        newPage.setTitle(title);
        newPage.setContent(content);
        newPage.setComment(comment);
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        Assert.assertNotNull((Object)link);
        PutMethod putMethod = this.executePutXml(link.getHref(), newPage, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)title, (Object)modifiedPage.getTitle());
        Assert.assertEquals((Object)content, (Object)modifiedPage.getContent());
        Assert.assertEquals((Object)comment, (Object)modifiedPage.getComment());
        GetMethod getMethod = this.executeGet(link.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        modifiedPage = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)title, (Object)modifiedPage.getTitle());
        Assert.assertEquals((Object)content, (Object)modifiedPage.getContent());
        Assert.assertEquals((Object)comment, (Object)modifiedPage.getComment());
    }

    @Test
    public void testPUTPageWithTextPlain() throws Exception {
        String CONTENT = String.format("This is a content (%d)", System.currentTimeMillis());
        Page originalPage = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        Assert.assertNotNull((Object)link);
        PutMethod putMethod = this.executePut(link.getHref(), CONTENT, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)CONTENT, (Object)modifiedPage.getContent());
    }

    @Test
    public void testPUTPageUnauthorized() throws Exception {
        Page page = this.getFirstPage();
        page.setContent("New content");
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "self");
        Assert.assertNotNull((Object)link);
        PutMethod putMethod = this.executePutXml(link.getHref(), page);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)401L, (long)putMethod.getStatusCode());
    }

    @Test
    public void testPUTNonExistingPage() throws Exception {
        String SPACE_NAME = "Test";
        String PAGE_NAME = String.format("Test-%d", System.currentTimeMillis());
        String CONTENT = String.format("Content %d", System.currentTimeMillis());
        String TITLE = String.format("Title %d", System.currentTimeMillis());
        String PARENT = "Main.WebHome";
        Page page = this.objectFactory.createPage();
        page.setContent(CONTENT);
        page.setTitle(TITLE);
        page.setParent("Main.WebHome");
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", PAGE_NAME}).toString(), page, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)CONTENT, (Object)modifiedPage.getContent());
        Assert.assertEquals((Object)TITLE, (Object)modifiedPage.getTitle());
        Assert.assertEquals((Object)"Main.WebHome", (Object)modifiedPage.getParent());
    }

    @Test
    public void testPUTWithInvalidRepresentation() throws Exception {
        Page page = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "self");
        PutMethod putMethod = this.executePut(link.getHref(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><invalidPage><content/></invalidPage>", "text/xml");
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)400L, (long)putMethod.getStatusCode());
    }

    @Test
    public void testPUTGETTranslation() throws Exception {
        this.createPageIfDoesntExist("Test", "Translations", "Translations");
        String[] languages = Locale.getISOLanguages();
        String languageId = languages[this.random.nextInt(languages.length)];
        Page page = this.objectFactory.createPage();
        page.setContent(languageId);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(PageTranslationResource.class).build(new Object[]{this.getWiki(), "Test", "Translations", languageId}).toString(), page, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)201L, (long)putMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageTranslationResource.class).build(new Object[]{this.getWiki(), "Test", "Translations", languageId}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)languageId, (Object)modifiedPage.getLanguage());
        Assert.assertEquals((Object)languageId, (Object)modifiedPage.getLanguage());
        Assert.assertTrue((modifiedPage.getTranslations().getTranslations().size() > 0 ? 1 : 0) != 0);
        for (Translation translation : modifiedPage.getTranslations().getTranslations()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)translation, "http://www.xwiki.org/rel/page").getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            modifiedPage = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            Assert.assertEquals((Object)modifiedPage.getLanguage(), (Object)translation.getLanguage());
            this.checkLinks((LinkCollection)translation);
        }
    }

    @Test
    public void testGETNotExistingTranslation() throws Exception {
        this.createPageIfDoesntExist("Test", "Translations", "Translations");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Translations"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTranslationResource.class).build(new Object[]{this.getWiki(), "Test", "Translations", "NOT_EXISTING"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testDELETEPage() throws Exception {
        String pageName = String.format("Test-%d", this.random.nextLong());
        this.createPageIfDoesntExist("Test", pageName, "Test page");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString(), TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (long)204L, (long)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)404L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testDELETEPageNoRights() throws Exception {
        String pageName = String.format("Test-%d", this.random.nextLong());
        this.createPageIfDoesntExist("Test", pageName, "Test page");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (long)401L, (long)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testPageHistory() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page originalPage = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        String pageHistoryUri = this.getUriBuilder(PageHistoryResource.class).build(new Object[]{this.getWiki(), originalPage.getSpace(), originalPage.getName()}).toString();
        getMethod = this.executeGet(pageHistoryUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        History history = (History)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        HistorySummary firstVersion = null;
        for (HistorySummary historySummary : history.getHistorySummaries()) {
            if ("1.1".equals(historySummary.getVersion())) {
                firstVersion = historySummary;
            }
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)historySummary, "http://www.xwiki.org/rel/page").getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            this.checkLinks((LinkCollection)page);
            for (Translation translation : page.getTranslations().getTranslations()) {
                this.checkLinks((LinkCollection)translation);
            }
        }
        Assert.assertNotNull(firstVersion);
        Assert.assertEquals((Object)"Imported from XAR", (Object)firstVersion.getComment());
    }

    @Test
    public void testPageTranslationHistory() throws Exception {
        String pageHistoryUri = this.getUriBuilder(PageHistoryResource.class).build(new Object[]{this.getWiki(), "Test", "Translations"}).toString();
        GetMethod getMethod = this.executeGet(pageHistoryUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        History history = (History)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (HistorySummary historySummary : history.getHistorySummaries()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)historySummary, "http://www.xwiki.org/rel/page").getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            this.checkLinks((LinkCollection)page);
            this.checkLinks((LinkCollection)page.getTranslations());
        }
    }

    @Test
    public void testGETPageChildren() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageChildrenResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((pages.getPageSummaries().size() > 0 ? 1 : 0) != 0);
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            this.checkLinks((LinkCollection)pageSummary);
        }
    }

    @Test
    public void testPOSTPageFormUrlEncoded() throws Exception {
        String CONTENT = String.format("This is a content (%d)", System.currentTimeMillis());
        String TITLE = String.format("Title (%s)", UUID.randomUUID().toString());
        Page originalPage = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        Assert.assertNotNull((Object)link);
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("title", TITLE), new NameValuePair("content", CONTENT)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", link.getHref()), nameValuePairs, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)202L, (long)postMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)CONTENT, (Object)modifiedPage.getContent());
        Assert.assertEquals((Object)TITLE, (Object)modifiedPage.getTitle());
    }

    @Test
    public void testPUTPageSyntax() throws Exception {
        Page originalPage = this.getFirstPage();
        GetMethod getMethod = this.executeGet(this.getFullUri(SyntaxesResource.class));
        Syntaxes syntaxes = (Syntaxes)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        String newSyntax = null;
        for (String syntax : syntaxes.getSyntaxes()) {
            if (syntax.equals(originalPage.getSyntax())) continue;
            newSyntax = syntax;
            break;
        }
        originalPage.setSyntax(newSyntax);
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        Assert.assertNotNull((Object)link);
        PutMethod putMethod = this.executePutXml(link.getHref(), originalPage, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)newSyntax, (Object)modifiedPage.getSyntax());
    }
}

