/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.UUID;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.tags.PagesForTagsResource;
import org.xwiki.rest.resources.tags.TagsResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;
import org.xwiki.test.ui.TestUtils;

public class TagsResourceTest
extends AbstractHttpTest {
    @Override
    @Test
    public void testRepresentation() throws Exception {
        String tagName = UUID.randomUUID().toString();
        this.createPageIfDoesntExist("Test", "Test", "Test");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Tags tags = this.objectFactory.createTags();
        Tag tag = this.objectFactory.createTag();
        tag.setName(tagName);
        tags.getTags().add(tag);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString(), tags, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        boolean found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        getMethod = this.executeGet(this.getUriBuilder(TagsResource.class).build(new Object[]{this.getWiki()}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        getMethod = this.executeGet(this.getUriBuilder(PagesForTagsResource.class).build(new Object[]{this.getWiki(), tagName}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        found = false;
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            if (!pageSummary.getFullName().equals(String.format("%s.%s", "Test", "Test"))) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link tagsLink = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/tags");
        Assert.assertNotNull((Object)tagsLink);
    }

    @Test
    public void testPUTTagsWithTextPlain() throws Exception {
        this.createPageIfDoesntExist("Test", "Test", "Test");
        String tagName = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        PutMethod putMethod = this.executePut(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString(), tagName, "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (long)202L, (long)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Tags tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        boolean found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testPUTTagsFormUrlEncoded() throws Exception {
        this.createPageIfDoesntExist("Test", "Test", "Test");
        String tagName = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("tags", tagName)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString()), nameValuePairs, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)202L, (long)postMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Tags tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        boolean found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }
}

