/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.storage.framework;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;

public final class TestUtils {
    public static final String[] ADMIN_CREDENTIALS = new String[]{"Admin", "admin"};

    public static String getPageAsString(String address) throws IOException {
        HttpMethod ret = TestUtils.doPost(address, null, null);
        return new String(ret.getResponseBody(), "UTF-8");
    }

    public static HttpMethod doPost(String address, String[] userNameAndPassword, Map<String, String> parameters) throws IOException {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(address);
        if (userNameAndPassword != null && userNameAndPassword.length == 2) {
            client.getState().setCredentials(null, null, (Credentials)new UsernamePasswordCredentials(userNameAndPassword[0], userNameAndPassword[1]));
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                method.addParameter(e.getKey(), e.getValue());
            }
        }
        client.executeMethod((HttpMethod)method);
        return method;
    }

    public static HttpMethod doUpload(String address, String[] userNameAndPassword, Map<String, byte[]> uploads) throws IOException {
        HttpClient client = new HttpClient();
        MultipartPostMethod method = new MultipartPostMethod(address);
        if (userNameAndPassword != null && userNameAndPassword.length == 2) {
            client.getState().setCredentials(null, null, (Credentials)new UsernamePasswordCredentials(userNameAndPassword[0], userNameAndPassword[1]));
        }
        for (Map.Entry<String, byte[]> e : uploads.entrySet()) {
            method.addPart((Part)new FilePart("filepath", (PartSource)new ByteArrayPartSource(e.getKey(), e.getValue())));
        }
        client.executeMethod((HttpMethod)method);
        return method;
    }

    public static String escapeURL(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

