/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.webdav;

import org.xwiki.test.webdav.AbstractWebDAVTest;

public class RootViewTest
extends AbstractWebDAVTest {
    public void testPropFind() {
        this.propFind("http://localhost:8080/xwiki/webdav", 1, 207);
    }

    public void testCreateCollection() {
        this.mkCol("http://localhost:8080/xwiki/webdav/collection", 405);
    }

    public void testCreateFile() {
        this.put("http://localhost:8080/xwiki/webdav/test.txt", "Content", 405);
    }

    public void testTempCollectionOperations() {
        String tempCollectionUrl = "http://localhost:8080/xwiki/webdav/.temp";
        this.mkCol(tempCollectionUrl, 201);
        this.move(tempCollectionUrl, "/xwiki/webdav/temp2", 405);
        this.move(tempCollectionUrl, "/xwiki/webdav/.temp2", 403);
        this.delete(tempCollectionUrl, 204);
    }

    public void testTempFileOperations() {
        String tempFileUrl = "http://localhost:8080/xwiki/webdav/temp.txt~";
        String destinationUrl = "http://localhost:8080/xwiki/webdav/.temp.txt";
        String relativeDestinationUrl = "/xwiki/webdav/.temp.txt";
        this.put(tempFileUrl, "Content", 201);
        this.get(tempFileUrl, 200);
        this.move(tempFileUrl, "/xwiki/webdav/temp.txt", 405);
        this.move(tempFileUrl, relativeDestinationUrl, 201);
        this.get(destinationUrl, 200);
        this.delete(destinationUrl, 204);
    }

    public void testMoveBaseViews() {
        String invalidDestination = "/xwiki/webdav/target";
        String validDestination = "/xwiki/webdav/.temp";
        for (String baseView : BASE_VIEWS) {
            this.move(baseView, invalidDestination, 405);
            this.move(baseView, validDestination, 405);
        }
    }

    public void testDeleteBaseViews() {
        for (String baseView : BASE_VIEWS) {
            this.delete(baseView, 403);
        }
    }
}

