/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.webdav;

import org.xwiki.test.webdav.AbstractWebDAVTest;

public class TempFileTest
extends AbstractWebDAVTest {
    public static final String TEMP_ROOT = "http://localhost:8080/xwiki/webdav/.temp";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mkCol(TEMP_ROOT, 201);
    }

    public void testTempCollectionOperations() {
        String tempCollectionUrl = "http://localhost:8080/xwiki/webdav/.temp/temp";
        this.mkCol(tempCollectionUrl, 201);
        this.move(tempCollectionUrl, "/xwiki/webdav/.temp/temp2", 403);
        this.delete(tempCollectionUrl, 204);
    }

    public void testTempFileOperations() {
        String tempFileUrl = "http://localhost:8080/xwiki/webdav/.temp/temp.txt";
        String destinationUrl = "http://localhost:8080/xwiki/webdav/.temp/temp2.txt";
        String relativeDestinationUrl = "/xwiki/webdav/.temp/temp2.txt";
        this.put(tempFileUrl, "Content", 201);
        this.get(tempFileUrl, 200);
        this.move(tempFileUrl, relativeDestinationUrl, 201);
        this.get(destinationUrl, 200);
        this.delete(destinationUrl, 204);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delete(TEMP_ROOT, 204);
    }
}

