/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc;

import java.util.Date;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.test.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.test.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiPage;

public class PagesTestWithGuest
extends AbstractXWikiXmlRpcTest {
    @Override
    public void setUp() throws Exception {
        String content;
        XWikiPage page;
        super.setUp();
        try {
            this.rpc.getPage("Test.Test");
        }
        catch (Exception e) {
            page = new XWikiPage();
            page.setId("Test.Test");
            page.setTitle("Test page");
            content = String.format("Modified by org.xwiki.xmlrpc @ %s (This will be version: %d)\n", new Date(), page.getVersion() + 1);
            page.setContent(content);
            this.rpc.storePage((Page)page);
        }
        try {
            this.rpc.getPage("Test.Translations");
        }
        catch (Exception e) {
            page = new XWikiPage();
            page.setId("Test.Translations");
            page.setTitle("Test page");
            content = String.format("Modified by org.xwiki.xmlrpc @ %s (This will be version: %d)\n", new Date(), page.getVersion() + 1);
            page.setContent(content);
            this.rpc.storePage((Page)page);
        }
        this.rpc.logout();
    }

    public void testRenderContent() throws Exception {
        TestUtils.banner("TEST: renderContent()");
        String html = this.rpc.renderContent("Test", "Test.Test", "");
        System.out.format("Rendered content: '%s'\n", html);
        PagesTestWithGuest.assertTrue((html.length() != 0 ? 1 : 0) != 0);
        html = this.rpc.renderContent("Test", "Test.Test", "{{groovy}}print 'programming'{{/groovy}}");
        System.out.format("Rendered content: '%s'\n", html);
        PagesTestWithGuest.assertTrue((html.length() != 0 ? 1 : 0) != 0);
        PagesTestWithGuest.assertTrue((!"<p>programming</p>".equals(html) ? 1 : 0) != 0);
    }
}

