/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.test.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.test.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiClassSummary;
import org.xwiki.xmlrpc.model.XWikiObject;
import org.xwiki.xmlrpc.model.XWikiObjectSummary;
import org.xwiki.xmlrpc.model.XWikiPage;

public class XWikiObjectsTest
extends AbstractXWikiXmlRpcTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.rpc.getPage("Test.Objects");
        }
        catch (Exception e) {
            XWikiPage page = new XWikiPage();
            page.setId("Test.Objects");
            page.setTitle("Test page with objects");
            page.setContent("Test page with objects");
            this.rpc.storePage((Page)page);
        }
    }

    public void testCreateTagsObject() throws Exception {
        XWikiObject tagsObject = new XWikiObject();
        tagsObject.setPageId("Test.Objects");
        tagsObject.setClassName("XWiki.TagClass");
        tagsObject.setPrettyName("PrettyName");
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(String.format("New-%d", this.random.nextInt()));
        tagsObject.setProperty("tags", tags);
        tagsObject = this.rpc.storeObject(tagsObject);
        TestUtils.banner("createTagsObject()");
        System.out.format("%s\n", tagsObject);
        XWikiObjectsTest.assertTrue((tagsObject.getId() != -1 ? 1 : 0) != 0);
        XWikiObjectsTest.assertEquals(tags, (Object)tagsObject.getProperty("tags"));
    }

    public void testGetXWikiObjects() throws Exception {
        List xwikiObjects = this.rpc.getObjects("Test.Objects");
        TestUtils.banner("TEST: getXWikiObjects()");
        for (XWikiObjectSummary xwikiObjectSummary : xwikiObjects) {
            System.out.format("%s\n", xwikiObjectSummary);
        }
        XWikiObjectsTest.assertFalse((boolean)xwikiObjects.isEmpty());
    }

    public void testGetXWikiTagObject() throws Exception {
        List xwikiObjects = this.rpc.getObjects("Test.Objects");
        XWikiObjectSummary tagsObjectSummary = null;
        for (XWikiObjectSummary xwikiObjectSummary : xwikiObjects) {
            if (!xwikiObjectSummary.getClassName().equals("XWiki.TagClass")) continue;
            tagsObjectSummary = xwikiObjectSummary;
        }
        XWikiObject tagsObject = this.rpc.getObject(tagsObjectSummary);
        TestUtils.banner("TEST: getXWikiTagObject()");
        System.out.format("%s\n", tagsObject);
        XWikiObjectsTest.assertEquals((String)tagsObjectSummary.getPageId(), (String)tagsObject.getPageId());
        XWikiObjectsTest.assertEquals((int)tagsObjectSummary.getId(), (int)tagsObject.getId());
        XWikiObjectsTest.assertEquals((String)tagsObjectSummary.getClassName(), (String)tagsObject.getClassName());
    }

    public void testSetTagsObject() throws Exception {
        List xwikiObjects = this.rpc.getObjects("Test.Objects");
        XWikiObjectSummary tagsObjectSummary = null;
        for (XWikiObjectSummary xwikiObjectSummary : xwikiObjects) {
            if (!xwikiObjectSummary.getClassName().equals("XWiki.TagClass")) continue;
            tagsObjectSummary = xwikiObjectSummary;
        }
        XWikiObject object = this.rpc.getObject(tagsObjectSummary);
        TestUtils.banner("TEST: setTagsObject()");
        System.out.format("%s\n", object);
        Object value = object.getProperty("tags");
        XWikiObjectsTest.assertTrue((boolean)(value instanceof List));
        List tags = (List)value;
        tags.add(new Integer(this.random.nextInt()).toString());
        this.rpc.storeObject(object);
        object = this.rpc.getObject(tagsObjectSummary);
        List newTags = (List)object.getProperty("tags");
        XWikiObjectsTest.assertTrue((newTags.size() == tags.size() ? 1 : 0) != 0);
        for (Object t : tags) {
            XWikiObjectsTest.assertTrue((boolean)newTags.contains(t));
        }
    }

    public void testRemoveObject() throws Exception {
        XWikiObject tagsObject = new XWikiObject();
        tagsObject.setPageId("Test.Objects");
        tagsObject.setClassName("XWiki.TagClass");
        tagsObject.setPrettyName("PrettyName");
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(String.format("New-%d", this.random.nextInt()));
        tagsObject.setProperty("tags", tags);
        tagsObject = this.rpc.storeObject(tagsObject);
        Boolean result = this.rpc.removeObject((XWikiObjectSummary)tagsObject);
        TestUtils.banner("removeObjectTest()");
        System.out.format("Object added: %s\n", tagsObject);
        System.out.format("Object removed = %b\n", result);
        List objects = this.rpc.getObjects(tagsObject.getPageId());
        boolean found = false;
        for (XWikiObjectSummary object : objects) {
            if (!object.getClassName().equals(tagsObject.getClassName()) || object.getId() != tagsObject.getId()) continue;
            found = true;
            break;
        }
        XWikiObjectsTest.assertFalse((boolean)found);
    }

    public void testCreateTagsObjectWithCheckVersion() throws Exception {
        XWikiObject tagsObject = new XWikiObject();
        tagsObject.setPageId("Test.Objects");
        tagsObject.setClassName("XWiki.TagClass");
        tagsObject.setPrettyName("PrettyName");
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(String.format("New-%d", this.random.nextInt()));
        tagsObject.setProperty("tags", tags);
        XWikiObject storedTagsObject = this.rpc.storeObject(tagsObject);
        TestUtils.banner("createTagsObjectWithCheckVersion()");
        System.out.format("%s\n", storedTagsObject);
        XWikiObjectsTest.assertTrue((storedTagsObject.getId() != -1 ? 1 : 0) != 0);
        XWikiObjectsTest.assertEquals(tags, (Object)storedTagsObject.getProperty("tags"));
        storedTagsObject = this.rpc.storeObject(tagsObject, Boolean.valueOf(true));
        XWikiObjectsTest.assertTrue((boolean)storedTagsObject.getPageId().equals(""));
    }

    public void testGetObjectAtPreviousVersion() throws Exception {
        XWikiObject tagsObject = new XWikiObject();
        tagsObject.setPageId("Test.Objects");
        tagsObject.setClassName("XWiki.TagClass");
        tagsObject.setPrettyName("PrettyName");
        List tags = new ArrayList<String>();
        tags.add(String.format("VERSION1", this.random.nextInt()));
        tagsObject.setProperty("tags", tags);
        TestUtils.banner("getObjectAtPreviousVersion()");
        XWikiObject storedTagsObject1 = this.rpc.storeObject(tagsObject);
        System.out.format("%s %s\n", storedTagsObject1.getProperty("tags"), storedTagsObject1);
        tags = new ArrayList();
        tags.add(String.format("VERSION2", this.random.nextInt()));
        storedTagsObject1.setProperty("tags", tags);
        XWikiObject storedTagsObject2 = this.rpc.storeObject(storedTagsObject1);
        System.out.format("%s %s\n", storedTagsObject2.getProperty("tags"), storedTagsObject2);
        XWikiObject object = this.rpc.getObject(storedTagsObject1.getPageId(), storedTagsObject1.getClassName(), Integer.valueOf(storedTagsObject1.getId()), Integer.valueOf(storedTagsObject1.getPageVersion()), Integer.valueOf(storedTagsObject1.getPageMinorVersion()));
        System.out.format("%s %s\n", object.getProperty("tags"), object);
        tags = (List)object.getProperty("tags");
        XWikiObjectsTest.assertTrue((boolean)tags.contains("VERSION1"));
    }

    public void testGetObjectByGuid() throws XmlRpcException {
        List objectSummaries = this.rpc.getObjects("Test.Objects");
        TestUtils.banner("getObjectByGuid()");
        System.out.format("%s\n", objectSummaries);
        XWikiObject object = this.rpc.getObject("Test.Objects", ((XWikiObjectSummary)objectSummaries.get(0)).getGuid());
        System.out.format("Guid '%s': %s\n", ((XWikiObjectSummary)objectSummaries.get(0)).getGuid(), object);
        XWikiObjectsTest.assertTrue((boolean)object.getGuid().equals(((XWikiObjectSummary)objectSummaries.get(0)).getGuid()));
    }

    public void testOverrideObjectGuid() throws XmlRpcException {
        String GUID = "overridden-guid";
        List objectSummaries = this.rpc.getObjects("Test.Objects");
        TestUtils.banner("getOverrideObjectGuid()");
        XWikiObject object = this.rpc.getObject("Test.Objects", ((XWikiObjectSummary)objectSummaries.get(0)).getGuid());
        object.setGuid("overridden-guid");
        this.rpc.storeObject(object);
        object = this.rpc.getObject("Test.Objects", "overridden-guid");
        System.out.format("%s\n", object);
        XWikiObjectsTest.assertTrue((boolean)object.getGuid().equals("overridden-guid"));
    }

    public void testCreateEmptyObjectsFromAllClasses() throws XmlRpcException {
        TestUtils.banner("createEmptyObjectsFromAllClasses()");
        List xwikiClasses = this.rpc.getClasses();
        for (XWikiClassSummary cs : xwikiClasses) {
            System.out.format("Storing object for class %s\n", cs.getId());
            XWikiObject object = new XWikiObject();
            object.setPageId("Test.Objects");
            object.setClassName(cs.getId());
            this.rpc.storeObject(object);
        }
    }
}

