/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.action.internal;

import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.action.Action;
import org.xwiki.action.ActionException;
import org.xwiki.action.ActionManager;
import org.xwiki.action.internal.DefaultActionChain;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.resource.Resource;

public class DefaultActionManager
implements ActionManager {
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;

    @Override
    public boolean execute(Resource resource) throws ActionException {
        boolean result;
        TreeSet<Action> orderedActions = new TreeSet<Action>();
        for (Action action : this.getActions()) {
            if (!action.getSupportedActionIds().contains(resource.getActionId())) continue;
            orderedActions.add(action);
        }
        if (!orderedActions.isEmpty()) {
            DefaultActionChain chain = new DefaultActionChain(orderedActions);
            chain.executeNext(resource);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    private List<Action> getActions() throws ActionException {
        try {
            return this.contextComponentManager.getInstanceList(Action.class);
        }
        catch (ComponentLookupException e) {
            throw new ActionException("Failed to locate Action components", e);
        }
    }
}

