/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client;

import com.xpn.xwiki.util.AbstractXWikiRunnable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.activeinstalls.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls.internal.client.PingSender;

public class ActiveInstallsPingThread
extends AbstractXWikiRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveInstallsPingThread.class);
    private static final long WAIT_TIME_FULL = 86400000L;
    private static final long WAIT_TIME_RETRY = 3000L;
    private static final long RETRIES = 3L;
    private PingSender manager;
    private ActiveInstallsConfiguration configuration;
    private long retryTimeout;

    public ActiveInstallsPingThread(ActiveInstallsConfiguration configuration, PingSender manager) {
        this.configuration = configuration;
        this.manager = manager;
    }

    protected void runInternal() throws InterruptedException {
        while (true) {
            this.sendPing();
            Thread.sleep(86400000L);
        }
    }

    void sendPing() throws InterruptedException {
        int count = 1;
        while ((long)count <= 3L) {
            try {
                this.manager.sendPing();
                break;
            }
            catch (Exception e) {
                String message = String.format("Failed to send Active Installation ping to [%s] (try [%s]). Error = [%s].", this.configuration.getPingInstanceURL(), count, ExceptionUtils.getRootCauseMessage((Throwable)e));
                if ((long)count == 3L) {
                    message = String.format("%s Will retry in [%s] seconds...", message, 86400L);
                }
                LOGGER.warn(message);
                if ((long)count < 3L) {
                    Thread.sleep(this.getRetryTimeout());
                }
                ++count;
            }
        }
    }

    void setRetryTimeout(long milliseconds) {
        this.retryTimeout = milliseconds;
    }

    private long getRetryTimeout() {
        return this.retryTimeout > -1L ? this.retryTimeout : 3000L;
    }
}

