/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Named(value="extensions")
@Singleton
public class ExtensionPingDataProvider
implements PingDataProvider {
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_FEATURES = "features";
    private static final String PROPERTY_EXTENSIONS = "extensions";
    @Inject
    private InstalledExtensionRepository extensionRepository;

    @Override
    public Map<String, Object> provideMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "string");
        map.put("index", "not_analyzed");
        HashMap<String, HashMap<String, String>> propertiesMap = new HashMap<String, HashMap<String, String>>();
        propertiesMap.put(PROPERTY_ID, map);
        propertiesMap.put(PROPERTY_VERSION, map);
        propertiesMap.put(PROPERTY_FEATURES, map);
        return Collections.singletonMap(PROPERTY_EXTENSIONS, Collections.singletonMap("properties", propertiesMap));
    }

    @Override
    public Map<String, Object> provideData() {
        Collection installedExtensions = this.extensionRepository.getInstalledExtensions();
        JSONObject[] extensions = new JSONObject[installedExtensions.size()];
        Iterator it = installedExtensions.iterator();
        int i = 0;
        while (it.hasNext()) {
            InstalledExtension extension = (InstalledExtension)it.next();
            HashMap<String, Object> extensionMap = new HashMap<String, Object>();
            extensionMap.put(PROPERTY_ID, extension.getId().getId());
            extensionMap.put(PROPERTY_VERSION, extension.getId().getVersion().toString());
            extensionMap.put(PROPERTY_FEATURES, extension.getFeatures().toArray());
            extensions[i] = JSONObject.fromObject(extensionMap);
            ++i;
        }
        return Collections.singletonMap(PROPERTY_EXTENSIONS, extensions);
    }
}

