/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client.data;

import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Search;
import io.searchbox.params.SearchType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.instance.InstanceIdManager;

@Component
@Named(value="date")
@Singleton
public class DatePingDataProvider
implements PingDataProvider {
    private static final String PROPERTY_FIRST_PING_DATE = "firstPingDate";
    private static final String PROPERTY_SINCE_DAYS = "sinceDays";
    private static final String PROPERTY_SERVER_TIME = "serverTime";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_MIN = "min";
    private static final String ERROR_MESSAGE = "Failed to compute the first ping date and the number of elapsed days since the first ping. This information has not been added to the Active Installs ping data. Reason [{}]";
    @Inject
    private JestClientManager jestClientManager;
    @Inject
    private InstanceIdManager instanceIdManager;
    @Inject
    private Logger logger;

    @Override
    public Map<String, Object> provideMapping() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(PROPERTY_FIRST_PING_DATE, Collections.singletonMap(PROPERTY_TYPE, "date"));
        propertiesMap.put(PROPERTY_SINCE_DAYS, Collections.singletonMap(PROPERTY_TYPE, "long"));
        return propertiesMap;
    }

    @Override
    public Map<String, Object> provideData() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        try {
            String instanceId = this.instanceIdManager.getInstanceId().toString();
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(this.constructSearchJSON(instanceId)).addIndex("installs")).addType("install2")).setSearchType(SearchType.COUNT).build();
            JestResult result = this.jestClientManager.getClient().execute((Action)search);
            if (!result.isSucceeded()) {
                this.logger.warn(ERROR_MESSAGE, (Object)result.getErrorMessage());
                return jsonMap;
            }
            Map aggregationsMap = (Map)result.getValue("aggregations");
            Map serverTimeMap = (Map)aggregationsMap.get(PROPERTY_SERVER_TIME);
            Object serverTimeObject = serverTimeMap.get(PROPERTY_VALUE);
            Map firstPingDateMap = (Map)aggregationsMap.get(PROPERTY_FIRST_PING_DATE);
            Object firstPingDateObject = firstPingDateMap.get(PROPERTY_VALUE);
            if (serverTimeObject != null && firstPingDateObject != null) {
                long sinceDays = Math.round(((Double)serverTimeObject - (Double)firstPingDateObject) / 8.64E7);
                jsonMap.put(PROPERTY_SINCE_DAYS, sinceDays);
                long firstPingDate = Math.round((Double)firstPingDateObject);
                jsonMap.put(PROPERTY_FIRST_PING_DATE, firstPingDate);
            } else {
                jsonMap.put(PROPERTY_SINCE_DAYS, 0);
            }
        }
        catch (Exception e) {
            this.logger.warn(ERROR_MESSAGE, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return jsonMap;
    }

    protected String constructSearchJSON(String instanceId) {
        HashMap<String, Map<String, Map<String, String>>> jsonMap = new HashMap<String, Map<String, Map<String, String>>>();
        jsonMap.put("query", Collections.singletonMap("term", Collections.singletonMap("instanceId", instanceId)));
        HashMap<String, Map<String, Map<String, String>>> aggsMap = new HashMap<String, Map<String, Map<String, String>>>();
        aggsMap.put(PROPERTY_SERVER_TIME, Collections.singletonMap(PROPERTY_MIN, Collections.singletonMap("script", "time()")));
        aggsMap.put(PROPERTY_FIRST_PING_DATE, Collections.singletonMap(PROPERTY_MIN, Collections.singletonMap("field", "_timestamp")));
        jsonMap.put("aggs", aggsMap);
        return JSONObject.fromObject(jsonMap).toString();
    }
}

