/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client;

import io.searchbox.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Index;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.mapping.PutMapping;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.internal.client.PingSender;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.instance.InstanceIdManager;

@Component
@Singleton
public class DefaultPingSender
implements PingSender {
    private static final String LATEST_FORMAT_VERSION = "1.0";
    private static final String INDEX = "installs";
    private static final String TYPE = "install";
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    @Inject
    private InstalledExtensionRepository extensionRepository;
    @Inject
    private JestClientManager jestClientManager;
    @Inject
    private InstanceIdManager instanceIdManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;

    @Override
    public void sendPing() throws Exception {
        JestClient client = this.jestClientManager.getClient();
        client.execute((Action)new CreateIndex.Builder(INDEX).build());
        PutMapping putMapping = new PutMapping.Builder(INDEX, TYPE, (Object)this.constructJSONMapping()).build();
        client.execute((Action)putMapping);
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)this.constructJSON()).index(INDEX)).type(TYPE)).id(this.instanceIdManager.getInstanceId().toString())).build();
        JestResult result = client.execute((Action)index);
        if (!result.isSucceeded()) {
            throw new Exception(result.getErrorMessage());
        }
    }

    private String constructJSONMapping() {
        return "{ \"install\" : { \"properties\" : { \"formatVersion\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\"date\" : {\"type\" : \"date\"},\"distributionId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\"distributionVersion\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\"extensions\" : { \"properties\" : {\"id\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\"version\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"}} }} } }";
    }

    private String constructJSON() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("formatVersion", LATEST_FORMAT_VERSION);
        jsonMap.put("date", DATE_FORMATTER.print(new Date().getTime()));
        CoreExtension distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        if (distributionExtension != null) {
            Version distributionVersion;
            String distributionId = distributionExtension.getId().getId();
            if (distributionId != null) {
                jsonMap.put("distributionId", distributionId);
            }
            if ((distributionVersion = distributionExtension.getId().getVersion()) != null) {
                jsonMap.put("distributionVersion", distributionVersion.toString());
            }
        }
        Collection installedExtensions = this.extensionRepository.getInstalledExtensions();
        JSONObject[] extensions = new JSONObject[installedExtensions.size()];
        Iterator it = installedExtensions.iterator();
        int i = 0;
        while (it.hasNext()) {
            InstalledExtension extension = (InstalledExtension)it.next();
            HashMap<String, String> extensionMap = new HashMap<String, String>();
            extensionMap.put("id", extension.getId().getId());
            extensionMap.put("version", extension.getId().getVersion().toString());
            extensions[i] = JSONObject.fromObject(extensionMap);
            ++i;
        }
        jsonMap.put("extensions", extensions);
        return JSONObject.fromObject(jsonMap).toString();
    }
}

