/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client;

import com.xpn.xwiki.util.AbstractXWikiRunnable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.activeinstalls.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls.internal.client.PingSender;

public class ActiveInstallsPingThread
extends AbstractXWikiRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveInstallsPingThread.class);
    private static final long WAIT_TIME = 86400000L;
    private PingSender manager;
    private ActiveInstallsConfiguration configuration;

    public ActiveInstallsPingThread(ActiveInstallsConfiguration configuration, PingSender manager) {
        this.configuration = configuration;
        this.manager = manager;
    }

    protected void runInternal() {
        while (true) {
            try {
                this.manager.sendPing();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to send Active Installation ping to [{}]. Error = [{}]. Will retry in [{}] seconds...", new Object[]{this.configuration.getPingInstanceURL(), ExceptionUtils.getRootCauseMessage((Throwable)e), 86400L});
            }
            try {
                Thread.sleep(86400000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

