/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client.data;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.instance.InstanceIdManager;

@Component
@Named(value="distribution")
@Singleton
public class DistributionPingDataProvider
implements PingDataProvider {
    private static final String PROPERTY_INSTANCE_ID = "instanceId";
    private static final String PROPERTY_DISTRIBUTION_VERSION = "distributionVersion";
    private static final String PROPERTY_DISTRIBUTION_ID = "distributionId";
    @Inject
    private Logger logger;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private InstanceIdManager instanceIdManager;

    @Override
    public Map<String, Object> provideMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "string");
        map.put("index", "not_analyzed");
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(PROPERTY_INSTANCE_ID, map);
        propertiesMap.put(PROPERTY_DISTRIBUTION_VERSION, map);
        propertiesMap.put(PROPERTY_DISTRIBUTION_ID, map);
        return propertiesMap;
    }

    @Override
    public Map<String, Object> provideData() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String instanceId = this.instanceIdManager.getInstanceId().toString();
        jsonMap.put(PROPERTY_INSTANCE_ID, instanceId);
        CoreExtension distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        if (distributionExtension != null) {
            Version distributionVersion;
            String distributionId = distributionExtension.getId().getId();
            if (distributionId != null) {
                jsonMap.put(PROPERTY_DISTRIBUTION_ID, distributionId);
            }
            if ((distributionVersion = distributionExtension.getId().getVersion()) != null) {
                jsonMap.put(PROPERTY_DISTRIBUTION_VERSION, distributionVersion.toString());
            }
        }
        return jsonMap;
    }
}

