/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.server;

import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Count;
import io.searchbox.core.Search;
import io.searchbox.params.SearchType;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.server.DataManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultDataManager
implements DataManager {
    @Inject
    private JestClientManager jestClientManager;
    @Inject
    private ConverterManager converterManager;

    @Override
    public JsonObject countInstalls(String indexType, String fullQuery, Map<String, Object> parameters) throws Exception {
        Count.Builder countBuilder = (Count.Builder)((Count.Builder)new Count.Builder().query(fullQuery).addIndex("installs")).addType(indexType);
        for (Map.Entry<String, Object> parameterEntry : parameters.entrySet()) {
            countBuilder.setParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return this.executeActionQuery((Action)countBuilder.build(), fullQuery).getJsonObject();
    }

    @Override
    public JsonObject searchInstalls(String indexType, String fullQuery, Map<String, Object> parameters) throws Exception {
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)new Search.Builder(fullQuery).addIndex("installs")).addType(indexType);
        if (parameters.containsKey("search_type")) {
            SearchType searchType = (SearchType)this.converterManager.convert(SearchType.class, parameters.get("search_type"));
            searchBuilder.setSearchType(searchType);
        }
        for (Map.Entry<String, Object> parameterEntry : parameters.entrySet()) {
            if (parameterEntry.getKey().equals("search_type")) continue;
            searchBuilder.setParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return this.executeActionQuery((Action)searchBuilder.build(), fullQuery).getJsonObject();
    }

    private JestResult executeActionQuery(Action action, String fullQuery) throws Exception {
        JestResult result = this.jestClientManager.getClient().execute(action);
        if (!result.isSucceeded()) {
            throw new Exception(String.format("Error while executing [%s] query [%s]: [%s], Reason: [%s]", action.getClass().getSimpleName(), fullQuery, result.getErrorMessage(), result.getJsonString()));
        }
        return result;
    }
}

