/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.server.script;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls.server.DataManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="activeinstalls")
@Singleton
public class ActiveInstallsScriptService
implements ScriptService {
    public static final String ACTIVEINSTALLS_ERROR_KEY = "scriptservice.activeinstalls.error";
    @Inject
    private Execution execution;
    @Inject
    private DataManager dataManager;

    public JsonObject countInstalls(String indexType, String fullQuery, Map<String, Object> parameters) {
        JsonObject result;
        this.setError(null);
        try {
            result = this.dataManager.countInstalls(indexType, fullQuery, parameters);
        }
        catch (Exception e) {
            this.setError(e);
            result = null;
        }
        return result;
    }

    public JsonObject countInstalls(String indexType, String fullQuery) {
        return this.countInstalls(indexType, fullQuery, Collections.emptyMap());
    }

    public JsonObject searchInstalls(String indexType, String fullQuery, Map<String, Object> parameters) {
        JsonObject result;
        this.setError(null);
        try {
            result = this.dataManager.searchInstalls(indexType, fullQuery, parameters);
        }
        catch (Exception e) {
            this.setError(e);
            result = null;
        }
        return result;
    }

    public JsonObject searchInstalls(String indexType, String fullQuery) {
        return this.searchInstalls(indexType, fullQuery, Collections.emptyMap());
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ACTIVEINSTALLS_ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(ACTIVEINSTALLS_ERROR_KEY, (Object)e);
    }
}

