/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.server;

import io.searchbox.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Count;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.server.DataManager;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultDataManager
implements DataManager {
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    @Inject
    private JestClientManager jestClientManager;

    @Override
    public long getTotalInstalls() throws Exception {
        return this.executeCount("{\"match_all\" : { }}");
    }

    @Override
    public long getActiveInstalls(int days) throws Exception {
        DateTime dt = new DateTime();
        dt = dt.plusDays(-days);
        String serializedDate = DATE_FORMATTER.print((ReadableInstant)dt);
        String query = "{\n  \"constant_score\" : {\n    \"filter\" : {\n      \"numeric_range\" : {\n        \"date\" : {\n          \"gte\" : \"" + serializedDate + "\"\n" + "        }\n" + "      }\n" + "    }\n" + "  }\n" + "}";
        return this.executeCount(query);
    }

    private long executeCount(String query) throws Exception {
        Count count = ((Count.Builder)((Count.Builder)new Count.Builder(query).addIndex("installs")).addType("install")).build();
        JestResult result = this.jestClientManager.getClient().execute((Action)count);
        return ((Double)result.getValue("count")).longValue();
    }
}

