/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.eventstreambridge;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.eventstreambridge.EventConverter;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityStreamConfiguration;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventGroup;
import org.xwiki.eventstream.EventStream;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class BridgeEventStream
implements EventStream {
    @Inject
    private Execution execution;
    @Inject
    private QueryManager qm;
    @Inject
    private EventConverter eventConverter;
    @Inject
    private ActivityStreamConfiguration activityStreamConfiguration;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public void addEvent(Event e) {
        try {
            XWikiContext context = this.getXWikiContext();
            ActivityStreamPlugin plugin = this.getPlugin(context);
            plugin.getActivityStream().addActivityEvent(this.eventConverter.convertEventToActivity(e), context);
        }
        catch (ActivityStreamException activityStreamException) {
            // empty catch block
        }
    }

    public void deleteEvent(Event e) {
        try {
            XWikiContext context = this.getXWikiContext();
            ActivityStreamPlugin plugin = this.getPlugin(context);
            plugin.getActivityStream().deleteActivityEvent(this.eventConverter.convertEventToActivity(e), context);
        }
        catch (ActivityStreamException activityStreamException) {
            // empty catch block
        }
    }

    public EventGroup getRelatedEvents(Event e) {
        XWikiContext context = this.getXWikiContext();
        ActivityStreamPlugin plugin = this.getPlugin(context);
        EventGroup result = new EventGroup();
        try {
            result.addEvents(this.convertActivitiesToEvents(plugin.getActivityStream().getRelatedEvents(this.eventConverter.convertEventToActivity(e), context)).toArray(new Event[0]));
        }
        catch (ActivityStreamException activityStreamException) {
            // empty catch block
        }
        return result;
    }

    public List<Event> searchEvents(Query query) throws QueryException {
        Query q = this.qm.createQuery("select event from ActivityEventImpl event " + query.getStatement(), query.getLanguage());
        for (Map.Entry entry : query.getNamedParameters().entrySet()) {
            q.bindValue((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : query.getPositionalParameters().entrySet()) {
            q.bindValue(((Integer)entry.getKey()).intValue(), entry.getValue());
        }
        q.setLimit(query.getLimit());
        q.setOffset(query.getOffset());
        if (this.activityStreamConfiguration.useMainStore()) {
            q.setWiki(this.wikiDescriptorManager.getMainWikiId());
        }
        List events = q.execute();
        return this.convertActivitiesToEvents(events);
    }

    public Event getEvent(String eventId) throws QueryException {
        List events;
        Query q = this.qm.createQuery("select event from ActivityEventImpl event where eventId = :eventId", "hql");
        q.bindValue("eventId", (Object)eventId);
        if (this.activityStreamConfiguration.useMainStore()) {
            q.setWiki(this.wikiDescriptorManager.getMainWikiId());
        }
        if ((events = q.execute()).isEmpty()) {
            return null;
        }
        return this.eventConverter.convertActivityToEvent((ActivityEvent)events.get(0));
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private ActivityStreamPlugin getPlugin(XWikiContext context) {
        return (ActivityStreamPlugin)context.getWiki().getPlugin("activitystream", context);
    }

    private List<Event> convertActivitiesToEvents(List<ActivityEvent> events) {
        ArrayList<Event> result = new ArrayList<Event>(events.size());
        for (ActivityEvent e : events) {
            result.add(this.eventConverter.convertActivityToEvent(e));
        }
        return result;
    }
}

