/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEventStatus;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.eventstreambridge.EventConverter;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityStreamConfiguration;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStatusManager;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.eventstream.internal.events.EventStatusAddOrUpdatedEvent;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultEventStatusManager
implements EventStatusManager {
    @Inject
    private QueryManager queryManager;
    @Inject
    private EventConverter eventConverter;
    @Inject
    private ActivityStreamConfiguration configuration;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ObservationManager observation;

    public List<EventStatus> getEventStatus(List<org.xwiki.eventstream.Event> events, List<String> entityIds) throws Exception {
        ArrayList<EventStatus> results = new ArrayList<EventStatus>();
        if (events.isEmpty() || entityIds.isEmpty()) {
            return results;
        }
        Query query = this.queryManager.createQuery("select eventStatus from ActivityEventStatusImpl eventStatus where eventStatus.activityEvent.id in :eventIds and eventStatus.entityId in :entityIds", "hql");
        query.bindValue("eventIds", this.getEventIds(events));
        query.bindValue("entityIds", entityIds);
        for (ActivityEventStatus activityEventStatus : query.execute()) {
            results.add((EventStatus)new DefaultEventStatus(this.eventConverter.convertActivityToEvent(activityEventStatus.getActivityEvent()), activityEventStatus.getEntityId(), activityEventStatus.isRead()));
        }
        for (org.xwiki.eventstream.Event event : events) {
            for (String entityId : entityIds) {
                if (this.isPresent(event, entityId, results)) continue;
                results.add((EventStatus)new DefaultEventStatus(event, entityId, false));
            }
        }
        Collections.sort(results, (status1, status2) -> status2.getEvent().getDate().compareTo(status1.getEvent().getDate()));
        return results;
    }

    private List<String> getEventIds(List<org.xwiki.eventstream.Event> events) {
        ArrayList<String> eventIds = new ArrayList<String>();
        for (org.xwiki.eventstream.Event event : events) {
            eventIds.add(event.getId());
        }
        return eventIds;
    }

    private boolean isPresent(org.xwiki.eventstream.Event event, String entityId, List<EventStatus> list) {
        for (EventStatus status : list) {
            if (!StringUtils.equals((CharSequence)status.getEvent().getId(), (CharSequence)event.getId()) || !StringUtils.equals((CharSequence)status.getEntityId(), (CharSequence)entityId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEventStatus(EventStatus eventStatus) throws Exception {
        ActivityEventStatus status = this.eventConverter.convertEventStatusToActivityStatus(eventStatus);
        if (this.configuration.useLocalStore()) {
            this.saveEventStatusInStore(status);
            this.observation.notify((Event)new EventStatusAddOrUpdatedEvent(), (Object)eventStatus);
        }
        if (this.configuration.useMainStore()) {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            String oriDatabase = context.getWikiId();
            context.setWikiId(context.getMainXWiki());
            try {
                this.saveEventStatusInStore(status);
            }
            finally {
                context.setWikiId(oriDatabase);
            }
            this.observation.notify((Event)new EventStatusAddOrUpdatedEvent(), (Object)eventStatus);
        }
    }

    private void saveEventStatusInStore(ActivityEventStatus eventStatus) throws ActivityStreamException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
        try {
            hibernateStore.beginTransaction(context);
            Session session = hibernateStore.getSession(context);
            session.save((Object)eventStatus);
            hibernateStore.endTransaction(context, true);
        }
        catch (XWikiException e) {
            hibernateStore.endTransaction(context, false);
            throw new ActivityStreamException(e);
        }
    }
}

