/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityStreamCleaner;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPlugin;
import com.xpn.xwiki.plugin.scheduler.AbstractJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ActivityStreamCleanerJob
extends AbstractJob
implements Job {
    protected void executeJob(JobExecutionContext jobContext) throws JobExecutionException {
        JobDataMap data = jobContext.getJobDetail().getJobDataMap();
        XWikiContext context = ((XWikiContext)data.get((Object)"context")).clone();
        context.getWiki().getStore().cleanUp(context);
        ActivityStreamPlugin plugin = (ActivityStreamPlugin)context.getWiki().getPlugin("activitystream", context);
        ArrayList<Object> parameters = new ArrayList<Object>();
        int days = ActivityStreamCleaner.getNumberOfDaysToKeep(context);
        if (days > 0) {
            parameters.add(DateUtils.addDays((Date)new Date(), (int)(days * -1)));
            try {
                List<ActivityEvent> events = plugin.getActivityStream().searchEvents("date < ?", false, true, 0, 0, parameters, context);
                for (ActivityEvent event : events) {
                    plugin.getActivityStream().deleteActivityEvent(event, context);
                }
            }
            catch (ActivityStreamException e) {
                // empty catch block
            }
        }
    }
}

