/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.internal.event.CommentAddedEvent;
import com.xpn.xwiki.internal.event.CommentDeletedEvent;
import com.xpn.xwiki.internal.event.CommentUpdatedEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStream;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityEventImpl;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityStreamCleaner;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPlugin;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.web.Utils;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.annotation.event.AnnotationAddedEvent;
import org.xwiki.annotation.event.AnnotationDeletedEvent;
import org.xwiki.annotation.event.AnnotationUpdatedEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

public class ActivityStreamImpl
implements ActivityStream,
EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityStreamImpl.class);
    private static final String REQUEST_ID_CONTEXT_KEY = "activitystream_requestid";
    private static final String EVENT_ID_ELEMENTS_SEPARATOR = "-";
    private static final String LISTENER_NAME = "activitystream";
    private static final List<Event> LISTENER_EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentCreatedEvent());
            this.add(new DocumentUpdatedEvent());
            this.add(new DocumentDeletedEvent());
            this.add(new CommentAddedEvent());
            this.add(new CommentDeletedEvent());
            this.add(new CommentUpdatedEvent());
            this.add(new AttachmentAddedEvent());
            this.add(new AttachmentDeletedEvent());
            this.add(new AttachmentUpdatedEvent());
            this.add(new AnnotationAddedEvent());
            this.add(new AnnotationDeletedEvent());
            this.add(new AnnotationUpdatedEvent());
        }
    };

    private void setEventDocumentRelatedInformation(ActivityEvent event, XWikiDocument doc, XWikiContext context) {
        if (doc != null) {
            if (event.getStream() == null) {
                event.setStream(this.getStreamName(doc.getSpace(), context));
            }
            if (event.getSpace() == null) {
                event.setSpace(doc.getSpace());
            }
            if (event.getPage() == null) {
                event.setPage(doc.getFullName());
            }
            if (event.getUrl() == null && context.getURLFactory() != null) {
                event.setUrl(doc.getURL("view", context));
            }
        }
    }

    private void prepareEvent(ActivityEvent event, XWikiDocument doc, XWikiContext context) {
        if (event.getUser() == null) {
            event.setUser(context.getUser());
        }
        if (event.getWiki() == null) {
            event.setWiki(context.getDatabase());
        }
        if (event.getApplication() == null) {
            event.setApplication("xwiki");
        }
        if (event.getDate() == null) {
            event.setDate(context.getWiki().getCurrentDate());
        }
        if (event.getEventId() == null) {
            event.setEventId(this.generateEventId(event, context));
        }
        if (event.getRequestId() == null) {
            event.setRequestId((String)context.get((Object)REQUEST_ID_CONTEXT_KEY));
        }
        this.setEventDocumentRelatedInformation(event, doc, context);
    }

    private String generateEventId(ActivityEvent event, XWikiContext context) {
        String keySeparator = EVENT_ID_ELEMENTS_SEPARATOR;
        String wikiSpaceSeparator = ":";
        String key = event.getStream() + keySeparator + event.getApplication() + keySeparator + event.getWiki() + wikiSpaceSeparator + event.getPage() + keySeparator + event.getType();
        long hash = key.hashCode();
        if (hash < 0L) {
            hash = -hash;
        }
        String id = "" + hash + keySeparator + event.getDate().getTime() + keySeparator + RandomStringUtils.randomAlphanumeric((int)8);
        if (context.get((Object)REQUEST_ID_CONTEXT_KEY) == null) {
            context.put((Object)REQUEST_ID_CONTEXT_KEY, (Object)id);
        }
        return id;
    }

    private ActivityEvent newActivityEvent() {
        return new ActivityEventImpl();
    }

    @Override
    public void init(XWikiContext context) throws XWikiException {
        ObservationManager observationManager = (ObservationManager)Utils.getComponent(ObservationManager.class);
        if (observationManager.getListener(this.getName()) == null) {
            observationManager.addListener((EventListener)this);
        }
        ActivityStreamCleaner.getInstance().init(context);
    }

    @Override
    public String getStreamName(String space, XWikiContext context) {
        return space;
    }

    @Override
    public void addActivityEvent(ActivityEvent event, XWikiContext context) throws ActivityStreamException {
        this.addActivityEvent(event, null, context);
    }

    private boolean useLocalStore(XWikiContext context) {
        if (!context.getWiki().isVirtualMode()) {
            return true;
        }
        if (!this.useMainStore(context)) {
            return true;
        }
        ActivityStreamPlugin plugin = (ActivityStreamPlugin)context.getWiki().getPlugin(LISTENER_NAME, context);
        return Integer.parseInt(plugin.getActivityStreamPreference("uselocalstore", "1", context)) == 1;
    }

    private boolean useMainStore(XWikiContext context) {
        if (!context.getWiki().isVirtualMode()) {
            return false;
        }
        if (context.getWiki().isVirtualMode() && context.getDatabase().equals(context.getMainXWiki())) {
            return false;
        }
        ActivityStreamPlugin plugin = (ActivityStreamPlugin)context.getWiki().getPlugin(LISTENER_NAME, context);
        return Integer.parseInt(plugin.getActivityStreamPreference("usemainstore", "1", context)) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityEvent(ActivityEvent event, XWikiDocument doc, XWikiContext context) throws ActivityStreamException {
        this.prepareEvent(event, doc, context);
        if (this.useLocalStore(context)) {
            XWikiHibernateStore localHibernateStore = context.getWiki().getHibernateStore();
            try {
                localHibernateStore.beginTransaction(context);
                Session session = localHibernateStore.getSession(context);
                session.save((Object)event);
                localHibernateStore.endTransaction(context, true);
            }
            catch (XWikiException e) {
                localHibernateStore.endTransaction(context, false);
            }
        }
        if (this.useMainStore(context)) {
            String oriDatabase = context.getDatabase();
            context.setDatabase(context.getMainXWiki());
            XWikiHibernateStore mainHibernateStore = context.getWiki().getHibernateStore();
            try {
                mainHibernateStore.beginTransaction(context);
                Session session = mainHibernateStore.getSession(context);
                session.save((Object)event);
                mainHibernateStore.endTransaction(context, true);
            }
            catch (XWikiException e) {
                mainHibernateStore.endTransaction(context, false);
            }
            finally {
                context.setDatabase(oriDatabase);
            }
        }
    }

    @Override
    public void addActivityEvent(String streamName, String type, String title, XWikiContext context) throws ActivityStreamException {
        this.addActivityEvent(streamName, type, title, null, context);
    }

    @Override
    public void addActivityEvent(String streamName, String type, String title, List<String> params, XWikiContext context) throws ActivityStreamException {
        ActivityEvent event = this.newActivityEvent();
        event.setStream(streamName);
        event.setType(type);
        event.setTitle(title);
        event.setBody(title);
        event.setParams(params);
        this.addActivityEvent(event, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, String title, XWikiContext context) throws ActivityStreamException {
        this.addDocumentActivityEvent(streamName, doc, type, 20, title, null, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, int priority, String title, XWikiContext context) throws ActivityStreamException {
        this.addDocumentActivityEvent(streamName, doc, type, priority, title, null, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, String title, List<String> params, XWikiContext context) throws ActivityStreamException {
        this.addDocumentActivityEvent(streamName, doc, type, 20, title, params, context);
    }

    @Override
    public void addDocumentActivityEvent(String streamName, XWikiDocument doc, String type, int priority, String title, List<String> params, XWikiContext context) throws ActivityStreamException {
        ActivityEvent event = this.newActivityEvent();
        event.setStream(streamName);
        event.setPage(doc.getFullName());
        if (doc.getDatabase() != null) {
            event.setWiki(doc.getDatabase());
        }
        event.setDate(doc.getDate());
        event.setPriority(priority);
        event.setType(type);
        event.setTitle(title);
        event.setBody(title);
        event.setVersion(doc.getVersion());
        event.setParams(params);
        event.setUser(doc.getAuthor());
        this.addActivityEvent(event, doc, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActivityEventImpl loadActivityEvent(ActivityEvent ev, boolean bTransaction, XWikiContext context) throws ActivityStreamException {
        boolean bTransactionMutable = bTransaction;
        ActivityEventImpl act = null;
        String eventId = ev.getEventId();
        if (this.useLocalStore(context)) {
            XWikiHibernateStore hibstore = context.getWiki().getHibernateStore();
            try {
                if (bTransactionMutable) {
                    hibstore.checkHibernate(context);
                    bTransactionMutable = hibstore.beginTransaction(false, context);
                }
                Session session = hibstore.getSession(context);
                Query query = session.createQuery("select act.eventId from ActivityEventImpl as act where act.eventId = :eventId");
                query.setString("eventId", eventId);
                if (query.uniqueResult() != null) {
                    act = new ActivityEventImpl();
                    session.load((Object)act, (Serializable)((Object)eventId));
                }
                if (!bTransactionMutable) return act;
                hibstore.endTransaction(context, false, false);
                return act;
            }
            catch (Exception e) {
                throw new ActivityStreamException();
            }
            finally {
                try {
                    if (bTransactionMutable) {
                        hibstore.endTransaction(context, false, false);
                    }
                }
                catch (Exception e) {}
            }
        }
        if (!this.useMainStore(context)) return act;
        String oriDatabase = context.getDatabase();
        context.setDatabase(context.getMainXWiki());
        XWikiHibernateStore hibstore = context.getWiki().getHibernateStore();
        try {
            if (bTransactionMutable) {
                hibstore.checkHibernate(context);
                bTransactionMutable = hibstore.beginTransaction(false, context);
            }
            Session session = hibstore.getSession(context);
            Query query = session.createQuery("select act.eventId from ActivityEventImpl as act where act.eventId = :eventId");
            query.setString("eventId", eventId);
            if (query.uniqueResult() != null) {
                act = new ActivityEventImpl();
                session.load((Object)act, (Serializable)((Object)eventId));
            }
            if (!bTransactionMutable) return act;
            hibstore.endTransaction(context, false, false);
            return act;
        }
        catch (Exception e) {
            throw new ActivityStreamException();
        }
        finally {
            context.setDatabase(oriDatabase);
            try {
                if (bTransactionMutable) {
                    hibstore.endTransaction(context, false, false);
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void deleteActivityEvent(ActivityEvent event, XWikiContext context) throws ActivityStreamException {
        Session session;
        XWikiHibernateStore hibstore;
        boolean bTransaction = true;
        ActivityEventImpl evImpl = this.loadActivityEvent(event, true, context);
        String oriDatabase = context.getDatabase();
        if (this.useLocalStore(context)) {
            if (context.getDatabase().equals(event.getWiki())) {
                hibstore = context.getWiki().getHibernateStore();
            } else {
                context.setDatabase(event.getWiki());
                hibstore = context.getWiki().getHibernateStore();
            }
            try {
                if (bTransaction) {
                    hibstore.checkHibernate(context);
                    bTransaction = hibstore.beginTransaction(context);
                }
                session = hibstore.getSession(context);
                session.delete((Object)evImpl);
                if (bTransaction) {
                    hibstore.endTransaction(context, true);
                }
            }
            catch (XWikiException e) {
                throw new ActivityStreamException();
            }
            finally {
                try {
                    if (bTransaction) {
                        hibstore.endTransaction(context, false);
                    }
                    if (context.getDatabase().equals(oriDatabase)) {
                        context.setDatabase(oriDatabase);
                    }
                }
                catch (Exception e) {}
            }
        }
        if (this.useMainStore(context)) {
            context.setDatabase(context.getMainXWiki());
            hibstore = context.getWiki().getHibernateStore();
            try {
                if (bTransaction) {
                    hibstore.checkHibernate(context);
                    bTransaction = hibstore.beginTransaction(context);
                }
                session = hibstore.getSession(context);
                session.delete((Object)evImpl);
                if (bTransaction) {
                    hibstore.endTransaction(context, true);
                }
            }
            catch (XWikiException e) {
                throw new ActivityStreamException();
            }
            finally {
                try {
                    if (bTransaction) {
                        hibstore.endTransaction(context, false);
                    }
                    context.setDatabase(oriDatabase);
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public List<ActivityEvent> searchEvents(String hql, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("", hql, filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String hql, boolean filter, boolean globalSearch, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("", hql, filter, globalSearch, nb, start, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String hql, boolean filter, boolean globalSearch, int nb, int start, List<Object> parameterValues, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("", hql, filter, globalSearch, nb, start, parameterValues, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents(fromHql, hql, filter, nb, start, null, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, boolean globalSearch, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents(fromHql, hql, filter, globalSearch, nb, start, null, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, int nb, int start, List<Object> parameterValues, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents(fromHql, hql, filter, false, nb, start, parameterValues, context);
    }

    @Override
    public List<ActivityEvent> searchEvents(String fromHql, String hql, boolean filter, boolean globalSearch, int nb, int start, List<Object> parameterValues, XWikiContext context) throws ActivityStreamException {
        List results;
        StringBuffer searchHql = new StringBuffer();
        if (filter) {
            searchHql.append("select act from ActivityEventImpl as act, ActivityEventImpl as act2 ");
            searchHql.append(fromHql);
            searchHql.append(" where act.eventId=act2.eventId and ");
            searchHql.append(hql);
            searchHql.append(" group by act.requestId having (act.priority)=max(act2.priority) order by act.date desc");
        } else {
            searchHql.append("select act from ActivityEventImpl as act ");
            searchHql.append(fromHql);
            searchHql.append(" where ");
            searchHql.append(hql);
            searchHql.append(" order by act.date desc");
        }
        if (globalSearch) {
            String oriDatabase = context.getDatabase();
            try {
                context.setDatabase(context.getMainXWiki());
                results = context.getWiki().getStore().search(searchHql.toString(), nb, start, parameterValues, context);
            }
            catch (XWikiException e) {
                throw new ActivityStreamException(e);
            }
            finally {
                context.setDatabase(oriDatabase);
            }
        }
        try {
            results = context.getWiki().getStore().search(searchHql.toString(), nb, start, parameterValues, context);
        }
        catch (XWikiException e) {
            throw new ActivityStreamException(e);
        }
        return results;
    }

    @Override
    public List<ActivityEvent> getEvents(boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("1=1", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForSpace(String space, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.space='" + space + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForUser(String user, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.user='" + user + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEvents(String stream, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.stream='" + stream + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForSpace(String stream, String space, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.space='" + space + "' and act.stream='" + stream + "'", filter, nb, start, context);
    }

    @Override
    public List<ActivityEvent> getEventsForUser(String stream, String user, boolean filter, int nb, int start, XWikiContext context) throws ActivityStreamException {
        return this.searchEvents("act.user='" + user + "' and act.stream='" + stream + "'", filter, nb, start, context);
    }

    @Override
    public SyndEntry getFeedEntry(ActivityEvent event, XWikiContext context) {
        return this.getFeedEntry(event, "", context);
    }

    @Override
    public SyndEntry getFeedEntry(ActivityEvent event, String suffix, XWikiContext context) {
        String url;
        SyndEntryImpl entry = new SyndEntryImpl();
        String user = event.getUser();
        String displayUser = context.getWiki().getUserName(user, null, false, context);
        entry.setAuthor(displayUser);
        event.setTitle(event.getTitle() + ".rss.title" + suffix);
        entry.setTitle(event.getDisplayTitle(context));
        event.setBody(event.getBody() + ".rss.body" + suffix);
        SyndContentImpl sc = new SyndContentImpl();
        sc.setValue(event.getDisplayBody(context));
        sc.setType("text/html");
        entry.setDescription((SyndContent)sc);
        try {
            url = new URL(context.getURL(), event.getUrl()).toString();
        }
        catch (MalformedURLException e) {
            url = event.getUrl();
        }
        entry.setLink(url);
        entry.setPublishedDate(event.getDate());
        entry.setUpdatedDate(event.getDate());
        return entry;
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, XWikiContext context) {
        return this.getFeed(events, "", context);
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, String suffix, XWikiContext context) {
        SyndFeedImpl feed = new SyndFeedImpl();
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (ActivityEvent event : events) {
            SyndEntry entry = this.getFeedEntry(event, suffix, context);
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, XWikiContext context) {
        return this.getFeed(events, author, title, description, copyright, encoding, url, "", context);
    }

    @Override
    public SyndFeed getFeed(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String suffix, XWikiContext context) {
        SyndFeed feed = this.getFeed(events, suffix, context);
        feed.setAuthor(author);
        feed.setDescription(description);
        feed.setCopyright(copyright);
        feed.setEncoding(encoding);
        feed.setLink(url);
        feed.setTitle(title);
        return feed;
    }

    @Override
    public String getFeedOutput(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String type, XWikiContext context) {
        return this.getFeedOutput(events, author, title, description, copyright, encoding, url, type, "", context);
    }

    @Override
    public String getFeedOutput(List<ActivityEvent> events, String author, String title, String description, String copyright, String encoding, String url, String type, String suffix, XWikiContext context) {
        SyndFeed feed = this.getFeed(events, author, title, description, copyright, encoding, url, suffix, context);
        return this.getFeedOutput(feed, type);
    }

    @Override
    public String getFeedOutput(SyndFeed feed, String type) {
        feed.setFeedType(type);
        StringWriter writer = new StringWriter();
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            output.output(feed, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public List<Event> getEvents() {
        return LISTENER_EVENTS;
    }

    public String getName() {
        return LISTENER_NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument currentDoc = (XWikiDocument)source;
        XWikiDocument originalDoc = currentDoc.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        String wiki = context.getDatabase();
        String msgPrefix = "activitystream.event.";
        String streamName = this.getStreamName(currentDoc.getSpace(), context);
        if (streamName == null) {
            return;
        }
        if (!((RemoteObservationManagerContext)Utils.getComponent(RemoteObservationManagerContext.class)).isRemoteState()) {
            String displayTitle;
            String eventType;
            String additionalIdentifier = null;
            if (event instanceof DocumentCreatedEvent) {
                eventType = "create";
                displayTitle = currentDoc.getDisplayTitle(context);
            } else if (event instanceof DocumentUpdatedEvent) {
                eventType = "update";
                displayTitle = originalDoc.getDisplayTitle(context);
            } else if (event instanceof DocumentDeletedEvent) {
                eventType = "delete";
                displayTitle = originalDoc.getDisplayTitle(context);
            } else if (event instanceof CommentAddedEvent) {
                eventType = "addComment";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((CommentAddedEvent)event).getIdentifier();
            } else if (event instanceof CommentDeletedEvent) {
                eventType = "deleteComment";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((CommentDeletedEvent)event).getIdentifier();
            } else if (event instanceof CommentUpdatedEvent) {
                eventType = "updateComment";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((CommentUpdatedEvent)event).getIdentifier();
            } else if (event instanceof AttachmentAddedEvent) {
                eventType = "addAttachment";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((AttachmentAddedEvent)event).getName();
            } else if (event instanceof AttachmentDeletedEvent) {
                eventType = "deleteAttachment";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((AttachmentDeletedEvent)event).getName();
            } else if (event instanceof AttachmentUpdatedEvent) {
                eventType = "updateAttachment";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((AttachmentUpdatedEvent)event).getName();
            } else if (event instanceof AnnotationAddedEvent) {
                eventType = "addAnnotation";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((AnnotationAddedEvent)event).getIdentifier();
            } else if (event instanceof AnnotationDeletedEvent) {
                eventType = "deleteAnnotation";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((AnnotationDeletedEvent)event).getIdentifier();
            } else {
                eventType = "updateAnnotation";
                displayTitle = currentDoc.getDisplayTitle(context);
                additionalIdentifier = ((AnnotationUpdatedEvent)event).getIdentifier();
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(displayTitle);
            if (additionalIdentifier != null) {
                params.add(additionalIdentifier);
            }
            try {
                this.addDocumentActivityEvent(streamName, currentDoc, eventType, msgPrefix + eventType, params, context);
            }
            catch (ActivityStreamException e) {
                LOGGER.error("Exception while trying to add a document activity event, updated document: [" + wiki + ":" + currentDoc.getFullName() + "]");
            }
        }
    }

    @Override
    public List<ActivityEvent> getRelatedEvents(ActivityEvent event, XWikiContext context) throws ActivityStreamException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(event.getRequestId());
        return this.searchEvents("", "act.requestId= ? ", false, false, 0, 0, params, context);
    }

    @Override
    public List<Object[]> searchUniquePages(String optionalWhereClause, int maxItems, int startAt, XWikiContext context) throws ActivityStreamException {
        return this.searchUniquePages(optionalWhereClause, null, maxItems, startAt, context);
    }

    @Override
    public List<Object[]> searchUniquePages(String optionalWhereClause, List<Object> parametersValues, int maxItems, int startAt, XWikiContext context) throws ActivityStreamException {
        List results;
        StringBuffer searchHql = new StringBuffer();
        searchHql.append("select act.page, max(act.date) from ActivityEventImpl as act");
        if (StringUtils.isNotBlank((CharSequence)optionalWhereClause)) {
            searchHql.append(" where ");
            searchHql.append(optionalWhereClause);
        }
        searchHql.append(" group by act.page order by 2 desc");
        String originalDatabase = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            results = context.getWiki().getStore().search(searchHql.toString(), maxItems, startAt, parametersValues, context);
        }
        catch (XWikiException e) {
            throw new ActivityStreamException(e);
        }
        finally {
            context.setDatabase(originalDatabase);
        }
        return results;
    }

    @Override
    public List<Object[]> searchDailyPages(String optionalWhereClause, int maxItems, int startAt, XWikiContext context) throws ActivityStreamException {
        return this.searchDailyPages(optionalWhereClause, null, maxItems, startAt, context);
    }

    @Override
    public List<Object[]> searchDailyPages(String optionalWhereClause, List<Object> parametersValues, int maxItems, int startAt, XWikiContext context) throws ActivityStreamException {
        StringBuffer searchHql = new StringBuffer();
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        searchHql.append("select year(act.date), month(act.date), day(act.date), act.page, max(act.date)from ActivityEventImpl as act");
        if (StringUtils.isNotBlank((CharSequence)optionalWhereClause)) {
            searchHql.append(" where ");
            searchHql.append(optionalWhereClause);
        }
        searchHql.append(" group by year(act.date), month(act.date), day(act.date), act.page order by 5 desc");
        String originalDatabase = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            List rawResults = context.getWiki().getStore().search(searchHql.toString(), maxItems, startAt, parametersValues, context);
            for (Object[] rawResult : rawResults) {
                results.add(new Object[]{rawResult[3], rawResult[4]});
            }
        }
        catch (XWikiException e) {
            throw new ActivityStreamException(e);
        }
        finally {
            context.setDatabase(originalDatabase);
        }
        return results;
    }
}

