/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.administration.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.administration.test.po.AdministrationSectionPage;
import org.xwiki.administration.test.po.AnnotationsPage;
import org.xwiki.administration.test.po.GlobalRightsAdministrationSectionPage;
import org.xwiki.administration.test.po.ImportAdministrationSectionPage;
import org.xwiki.administration.test.po.LocalizationAdministrationSectionPage;
import org.xwiki.administration.test.po.PageElementsAdministrationSectionPage;
import org.xwiki.administration.test.po.UsersAdministrationSectionPage;
import org.xwiki.administration.test.po.WYSIWYGEditorAdministrationSectionPage;
import org.xwiki.test.ui.po.ViewPage;

public class AdministrationPage
extends ViewPage {
    @FindBy(xpath="//a[contains(@href, 'section=Localization')]")
    WebElement localizationLink;
    @FindBy(xpath="//a[contains(@href, 'section=Import')]")
    WebElement importLink;
    @FindBy(xpath="//a[contains(@href, 'section=Registration')]")
    WebElement registrationLink;
    @FindBy(xpath="//a[contains(@href, 'section=Users')]")
    WebElement usersLink;
    @FindBy(xpath="//a[contains(@href, 'section=Rights')]")
    WebElement rightsLink;
    @FindBy(xpath="//a[contains(@href, 'section=Annotations')]")
    WebElement annotationsLink;
    @FindBy(xpath="//a[contains(@href, 'section=Extension Manager')]")
    WebElement extensionsLink;
    @FindBy(xpath="//a[contains(@href, 'section=WYSIWYG')]")
    WebElement wysiwygLink;
    @FindBy(xpath="//a[contains(@href, 'section=Elements')]")
    private WebElement pageElementsLink;
    @FindBy(id="goto-select")
    WebElement spaceAdminSelect;

    public static AdministrationPage gotoPage() {
        AdministrationPage.getUtil().gotoPage("XWiki", "XWikiPreferences", "admin");
        return new AdministrationPage();
    }

    public LocalizationAdministrationSectionPage clickLocalizationSection() {
        this.localizationLink.click();
        return new LocalizationAdministrationSectionPage();
    }

    public ImportAdministrationSectionPage clickImportSection() {
        this.importLink.click();
        return new ImportAdministrationSectionPage();
    }

    public AdministrationSectionPage clickRegistrationSection() {
        this.registrationLink.click();
        return new AdministrationSectionPage("register");
    }

    public UsersAdministrationSectionPage clickUsersSection() {
        this.usersLink.click();
        return new UsersAdministrationSectionPage();
    }

    public GlobalRightsAdministrationSectionPage clickGlobalRightsSection() {
        this.rightsLink.click();
        return new GlobalRightsAdministrationSectionPage();
    }

    public AnnotationsPage clickAnnotationsSection() {
        this.annotationsLink.click();
        return new AnnotationsPage();
    }

    public WYSIWYGEditorAdministrationSectionPage clickWYSIWYGEditorSection() {
        this.wysiwygLink.click();
        return new WYSIWYGEditorAdministrationSectionPage();
    }

    public PageElementsAdministrationSectionPage clickPageElementsSection() {
        this.pageElementsLink.click();
        return new PageElementsAdministrationSectionPage();
    }

    public boolean hasSection(String sectionName) {
        return AdministrationPage.getUtil().hasElement(By.xpath((String)("//*[contains(@class, 'admin-menu')]//a[contains(@href, 'section=" + sectionName + "')]")));
    }

    public boolean hasNotSection(String sectionName) {
        return AdministrationPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)("//*[contains(@class, 'admin-menu')]//a[contains(@href, 'section=" + sectionName + "')]"))).size() == 0;
    }

    public AdministrationPage selectSpaceToAdminister(String spaceName) {
        Select select = new Select(this.spaceAdminSelect);
        select.selectByVisibleText(spaceName);
        return new AdministrationPage();
    }
}

