/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.administration.test.po;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.ConfirmationModal;
import org.xwiki.test.ui.po.ViewPage;

public class ImportAdministrationSectionPage
extends ViewPage {
    @FindBy(id="packagelistcontainer")
    private WebElement packageList;
    @FindBy(id="xwikiuploadfile")
    private WebElement uploadFileInputField;
    @FindBy(xpath="//*[@id='attachform']//input[@type='submit']")
    private WebElement uploadFileSubmit;
    @FindBy(xpath="//input[@value='Import']")
    private WebElement importPackageLink;

    public static ImportAdministrationSectionPage gotoPage() {
        ImportAdministrationSectionPage.getUtil().gotoPage("XWiki", "XWikiPreferences", "import", "editor=globaladmin&section=Import");
        return new ImportAdministrationSectionPage();
    }

    public void attachPackage(URL file) {
        this.uploadFileInputField.sendKeys(new CharSequence[]{file.getPath()});
        this.uploadFileSubmit.submit();
    }

    public boolean isPackagePresent(String packageName) {
        return this.getPackageNames().contains(packageName);
    }

    public List<String> getPackageNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (WebElement element : ImportAdministrationSectionPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)"//div[@id='packagelistcontainer']//a[@class='package']"))) {
            names.add(element.getText());
        }
        return names;
    }

    public void selectPackage(String packageName) {
        this.getDriver().findElement(By.linkText((String)packageName)).click();
        this.waitUntilElementIsVisible(By.id((String)"packageDescription"));
    }

    public void deletePackage(String packageName) {
        String xpath = "//ul[@class='xlist']//a[@class='package' and contains(.,'%s')]/..//a[@class='deletelink']";
        this.packageList.findElement(By.xpath((String)String.format(xpath, packageName))).click();
        ConfirmationModal confirmationModal = new ConfirmationModal();
        confirmationModal.clickOk();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[contains(@class,'xnotification-done') and text()='Done!']"));
        this.getDriver().findElement(By.xpath((String)"//div[contains(@class,'xnotification-done') and text()='Done!']")).click();
    }

    public void importPackage() {
        this.importPackageLink.click();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='packagecontainer']/div[@class='infomessage']"));
    }

    public ViewPage clickImportedPage(String pageName) {
        this.waitUntilElementIsVisible(By.linkText((String)pageName));
        this.getDriver().findElement(By.linkText((String)pageName)).click();
        return new ViewPage();
    }

    public void selectReplaceHistoryOption() {
        this.getDriver().findElement(By.xpath((String)"//input[@name='historyStrategy' and @value='replace']")).click();
    }
}

