/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.io.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.annotation.io.IOServiceException;
import org.xwiki.annotation.io.IOTargetService;
import org.xwiki.annotation.reference.IndexedObjectReference;
import org.xwiki.annotation.reference.TypedStringEntityReferenceResolver;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultIOTargetService
implements IOTargetService {
    @Inject
    private DocumentAccessBridge dab;
    @Inject
    private TypedStringEntityReferenceResolver referenceResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public String getSource(String reference) throws IOServiceException {
        try {
            EntityReference ref = this.referenceResolver.resolve(reference, EntityType.DOCUMENT);
            if (ref.getType() == EntityType.OBJECT_PROPERTY) {
                EntityReference docRef = ref.extractReference(EntityType.DOCUMENT);
                IndexedObjectReference objRef = new IndexedObjectReference(ref.getParent());
                if (objRef.getObjectNumber() != null) {
                    return this.dab.getProperty((String)this.serializer.serialize(docRef, new Object[0]), objRef.getClassName(), objRef.getObjectNumber().intValue(), ref.getName()).toString();
                }
                return this.dab.getProperty((String)this.serializer.serialize(docRef, new Object[0]), objRef.getClassName(), ref.getName()).toString();
            }
            if (ref.getType() == EntityType.DOCUMENT) {
                return this.dab.getDocumentContent((String)this.serializer.serialize(ref, new Object[0]));
            }
            return this.dab.getDocumentContent(reference);
        }
        catch (Exception e) {
            throw new IOServiceException("An exception has occurred while getting the source for " + reference, (Throwable)e);
        }
    }

    public String getSourceSyntax(String reference) throws IOServiceException {
        try {
            EntityReference ref = this.referenceResolver.resolve(reference, EntityType.DOCUMENT);
            EntityReference docRef = ref.extractReference(EntityType.DOCUMENT);
            if (docRef != null) {
                return this.dab.getDocumentSyntaxId((String)this.serializer.serialize(docRef, new Object[0]));
            }
            return this.dab.getDocumentSyntaxId(reference);
        }
        catch (Exception e) {
            throw new IOServiceException("An exception has occurred while getting the syntax of the source for " + reference, (Throwable)e);
        }
    }
}

