/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rights.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.io.IOService;
import org.xwiki.annotation.reference.TypedStringEntityReferenceResolver;
import org.xwiki.annotation.rights.AnnotationRightService;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class XWikiAnnotationRightService
implements AnnotationRightService {
    @Inject
    private Execution execution;
    @Inject
    private TypedStringEntityReferenceResolver referenceResolver;
    @Inject
    private IOService annotationsStorageService;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;

    public boolean canAddAnnotation(String target, String userName) {
        XWikiContext xwikiContext = this.getXWikiContext();
        try {
            return xwikiContext.getWiki().getRightService().hasAccessLevel("comment", userName, this.getDocumentReference(target), xwikiContext);
        }
        catch (XWikiException e) {
            this.logException((Exception)((Object)e), target, userName);
            return false;
        }
    }

    public boolean canEditAnnotation(String annotationId, String target, String userName) {
        XWikiContext xwikiContext = this.getXWikiContext();
        try {
            boolean hasEditRight = xwikiContext.getWiki().getRightService().hasAccessLevel("edit", userName, this.getDocumentReference(target), xwikiContext);
            if (hasEditRight) {
                return true;
            }
            Annotation ann = this.annotationsStorageService.getAnnotation(target, annotationId);
            return ann != null && ann.getAuthor().equals(userName);
        }
        catch (Exception e) {
            this.logException(e, target, userName);
            return false;
        }
    }

    public boolean canViewAnnotatedTarget(String target, String userName) {
        return this.canViewAnnotations(target, userName);
    }

    public boolean canViewAnnotations(String target, String userName) {
        XWikiContext xwikiContext = this.getXWikiContext();
        try {
            return xwikiContext.getWiki().getRightService().hasAccessLevel("view", userName, this.getDocumentReference(target), xwikiContext);
        }
        catch (XWikiException e) {
            this.logException((Exception)((Object)e), target, userName);
            return false;
        }
    }

    private String getDocumentReference(String target) {
        EntityReference ref = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
        String docName = target;
        if (ref.getType() == EntityType.DOCUMENT || ref.getType() == EntityType.OBJECT_PROPERTY) {
            docName = (String)this.serializer.serialize(ref.extractReference(EntityType.DOCUMENT), new Object[0]);
        }
        return docName;
    }

    private void logException(Exception e, String target, String user) {
        this.logger.warn("Couldn't get access rights for the target [" + target + "] for user [" + user + "]", (Throwable)e);
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

