/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Role;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.event.filter.EventFilter;
import org.xwiki.observation.event.filter.RegexEventFilter;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Role
@Named(value="CheckAnnotationClassEventListener")
@Singleton
public class CheckAnnotationClassEventListener
implements EventListener {
    static final String NAME = "CheckAnnotationClassEventListener";
    private static final RegexEventFilter CONFIGURATION_DOCUMENT_REFERENCE = new RegexEventFilter(String.format(".*:%s.%s", "AnnotationCode", "AnnotationConfig"));
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdatedEvent((EventFilter)CONFIGURATION_DOCUMENT_REFERENCE), new DocumentCreatedEvent((EventFilter)CONFIGURATION_DOCUMENT_REFERENCE));
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected WikiDescriptorManager wikiManager;
    @Inject
    protected AnnotationConfiguration configuration;
    @Inject
    @Named(value="annotationclass")
    protected MandatoryDocumentInitializer initializer;
    @Inject
    protected Logger logger;

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        DocumentReference annotationClassReference = this.configuration.getAnnotationClassReference();
        try {
            if (!this.configuration.isInstalled()) {
                return;
            }
            XWikiContext deprecatedContext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument annotationClassDocument = deprecatedContext.getWiki().getDocument(annotationClassReference, deprecatedContext);
            if (this.initializer.updateDocument(annotationClassDocument)) {
                deprecatedContext.getWiki().saveDocument(annotationClassDocument, "Automatically added missing annotation class fields required by the Annotation Application.", deprecatedContext);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update the configured annotation class [{}]", (Object)annotationClassReference, (Object)e);
        }
    }
}

