/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.io.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.annotation.io.IOService;
import org.xwiki.annotation.io.IOServiceException;
import org.xwiki.annotation.maintainer.AnnotationState;
import org.xwiki.annotation.reference.TypedStringEntityReferenceResolver;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultIOService
implements IOService {
    @Inject
    private Execution execution;
    @Inject
    private TypedStringEntityReferenceResolver referenceResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private Logger logger;
    @Inject
    private AnnotationConfiguration configuration;

    public void addAnnotation(String target, Annotation annotation) throws IOServiceException {
        try {
            String documentFullName = target;
            EntityReference targetReference = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
            EntityReference docRef = targetReference.extractReference(EntityType.DOCUMENT);
            if (docRef != null) {
                documentFullName = (String)this.serializer.serialize(docRef, new Object[0]);
            }
            XWikiContext deprecatedContext = this.getXWikiContext();
            XWikiDocument document = deprecatedContext.getWiki().getDocument(documentFullName, deprecatedContext);
            DocumentReference annotationClassReference = this.configuration.getAnnotationClassReference();
            annotationClassReference = annotationClassReference.removeParent(annotationClassReference.extractReference(EntityType.WIKI));
            int id = document.createXObject((EntityReference)annotationClassReference, deprecatedContext);
            BaseObject object = document.getXObject(this.configuration.getAnnotationClassReference(), id);
            this.updateObject(object, annotation, deprecatedContext);
            object.set("date", (Object)new Date(), deprecatedContext);
            object.set("author", (Object)annotation.getAuthor(), deprecatedContext);
            if (targetReference.getType() == EntityType.OBJECT_PROPERTY || targetReference.getType() == EntityType.DOCUMENT) {
                object.set("target", this.localSerializer.serialize(targetReference, new Object[0]), deprecatedContext);
            } else {
                object.set("target", (Object)target, deprecatedContext);
            }
            document.setAuthor(deprecatedContext.getUser());
            deprecatedContext.getWiki().saveDocument(document, "Added annotation on \"" + StringUtils.abbreviate((String)annotation.getSelection(), (int)30) + "\"", deprecatedContext);
        }
        catch (XWikiException e) {
            throw new IOServiceException("An exception message has occurred while saving the annotation", (Throwable)e);
        }
    }

    public Collection<Annotation> getAnnotations(String target) throws IOServiceException {
        try {
            EntityReference targetReference = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
            String localTargetId = target;
            String docName = target;
            if (targetReference.getType() == EntityType.DOCUMENT || targetReference.getType() == EntityType.OBJECT_PROPERTY) {
                localTargetId = (String)this.localSerializer.serialize(targetReference, new Object[0]);
                docName = (String)this.serializer.serialize(targetReference.extractReference(EntityType.DOCUMENT), new Object[0]);
            }
            XWikiContext deprecatedContext = this.getXWikiContext();
            XWikiDocument document = deprecatedContext.getWiki().getDocument(docName, deprecatedContext);
            List objects = document.getXObjects(this.configuration.getAnnotationClassReference());
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            if (objects == null) {
                return Collections.emptySet();
            }
            for (BaseObject object : objects) {
                if (object == null || !localTargetId.equals(object.getStringValue("target"))) continue;
                result.add(this.loadAnnotationFromObject(object, deprecatedContext));
            }
            return result;
        }
        catch (XWikiException e) {
            throw new IOServiceException("An exception has occurred while loading the annotations", (Throwable)e);
        }
    }

    public Annotation getAnnotation(String target, String annotationID) throws IOServiceException {
        try {
            XWikiContext deprecatedContext;
            XWikiDocument document;
            BaseObject object;
            if (annotationID == null || target == null) {
                return null;
            }
            EntityReference targetReference = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
            String localTargetId = target;
            String docName = target;
            if (targetReference.getType() == EntityType.DOCUMENT || targetReference.getType() == EntityType.OBJECT_PROPERTY) {
                localTargetId = (String)this.localSerializer.serialize(targetReference, new Object[0]);
                docName = (String)this.serializer.serialize(targetReference.extractReference(EntityType.DOCUMENT), new Object[0]);
            }
            if ((object = (document = (deprecatedContext = this.getXWikiContext()).getWiki().getDocument(docName, deprecatedContext)).getXObject(this.configuration.getAnnotationClassReference(), Integer.valueOf(annotationID.toString()).intValue())) == null || !localTargetId.equals(object.getStringValue("target"))) {
                return null;
            }
            return this.loadAnnotationFromObject(object, deprecatedContext);
        }
        catch (NumberFormatException e) {
            throw new IOServiceException("Could not parse annotation id " + annotationID, (Throwable)e);
        }
        catch (XWikiException e) {
            throw new IOServiceException("An exception has occurred while loading the annotation with id " + annotationID, (Throwable)e);
        }
    }

    public void removeAnnotation(String target, String annotationID) throws IOServiceException {
        try {
            XWikiContext deprecatedContext;
            XWikiDocument document;
            if (annotationID == null || target == null) {
                return;
            }
            EntityReference targetReference = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
            String localTargetId = target;
            String docName = target;
            if (targetReference.getType() == EntityType.DOCUMENT || targetReference.getType() == EntityType.OBJECT_PROPERTY) {
                localTargetId = (String)this.localSerializer.serialize(targetReference, new Object[0]);
                docName = (String)this.serializer.serialize(targetReference.extractReference(EntityType.DOCUMENT), new Object[0]);
            }
            if ((document = (deprecatedContext = this.getXWikiContext()).getWiki().getDocument(docName, deprecatedContext)).isNew()) {
                return;
            }
            BaseObject annotationObject = document.getXObject(this.configuration.getAnnotationClassReference(), Integer.valueOf(annotationID.toString()).intValue());
            if (annotationObject != null && localTargetId.equals(annotationObject.getStringValue("target"))) {
                document.removeObject(annotationObject);
                document.setAuthor(deprecatedContext.getUser());
                deprecatedContext.getWiki().saveDocument(document, "Deleted annotation " + annotationID, deprecatedContext);
            }
        }
        catch (NumberFormatException e) {
            throw new IOServiceException("An exception has occurred while parsing the annotation id", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new IOServiceException("An exception has occurred while removing the annotation", (Throwable)e);
        }
    }

    public void updateAnnotations(String target, Collection<Annotation> annotations) throws IOServiceException {
        try {
            EntityReference targetReference = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
            String docName = target;
            if (targetReference.getType() == EntityType.DOCUMENT || targetReference.getType() == EntityType.OBJECT_PROPERTY) {
                docName = (String)this.serializer.serialize(targetReference.extractReference(EntityType.DOCUMENT), new Object[0]);
            }
            XWikiContext deprecatedContext = this.getXWikiContext();
            XWikiDocument document = deprecatedContext.getWiki().getDocument(docName, deprecatedContext);
            ArrayList<String> updateNotifs = new ArrayList<String>();
            boolean updated = false;
            for (Annotation annotation : annotations) {
                int annId = 0;
                try {
                    annId = Integer.parseInt(annotation.getId());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                BaseObject object = document.getXObject(this.configuration.getAnnotationClassReference(), annId);
                if (object == null) continue;
                updated = this.updateObject(object, annotation, deprecatedContext) || updated;
                updateNotifs.add(annotation.getId());
            }
            if (updated) {
                document.setAuthor(deprecatedContext.getUser());
                deprecatedContext.getWiki().saveDocument(document, "Updated annotations", deprecatedContext);
            }
        }
        catch (XWikiException e) {
            throw new IOServiceException("An exception has occurred while updating the annotation", (Throwable)e);
        }
    }

    protected Annotation loadAnnotationFromObject(BaseObject object, XWikiContext deprecatedContext) {
        Annotation annotation = new Annotation(object.getNumber() + "");
        annotation.setState(AnnotationState.valueOf((String)object.getStringValue("state")));
        String originalSelection = object.getStringValue("originalSelection");
        if (originalSelection != null && originalSelection.length() > 0) {
            annotation.setOriginalSelection(originalSelection);
        }
        List<String> skippedFields = Arrays.asList("originalSelection", "state");
        for (String propName : object.getPropertyNames()) {
            if (skippedFields.contains(propName)) continue;
            try {
                annotation.set(propName, ((BaseProperty)object.get(propName)).getValue());
            }
            catch (XWikiException e) {
                this.logger.warn("Unable to get property " + propName + " from object " + object.getClassName() + "[" + object.getNumber() + "]. Will not be saved in the annotation.", (Throwable)e);
            }
        }
        return annotation;
    }

    protected boolean updateObject(BaseObject object, Annotation annotation, XWikiContext deprecatedContext) {
        boolean updated = false;
        updated = this.setIfNotNull(object, "state", annotation.getState() == null ? null : annotation.getState().toString(), deprecatedContext) || updated;
        List<String> skippedFields = Arrays.asList("state", "date", "author", "target");
        for (String propName : annotation.getFieldNames()) {
            if (skippedFields.contains(propName)) continue;
            updated = this.setIfNotNull(object, propName, annotation.get(propName), deprecatedContext) || updated;
        }
        return updated;
    }

    protected boolean setIfNotNull(BaseObject object, String fieldName, Object newValue, XWikiContext deprecatedContext) {
        if (newValue != null) {
            object.set(fieldName, newValue, deprecatedContext);
            return true;
        }
        return false;
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

