/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rights.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.io.IOService;
import org.xwiki.annotation.reference.TypedStringEntityReferenceResolver;
import org.xwiki.annotation.rights.AnnotationRightService;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class XWikiAnnotationRightService
implements AnnotationRightService {
    @Inject
    private TypedStringEntityReferenceResolver referenceResolver;
    @Inject
    private IOService annotationsStorageService;
    @Inject
    private AuthorizationManager authorization;
    @Inject
    @Named(value="user/current")
    private DocumentReferenceResolver<String> userAndGroupReferenceResolver;
    @Inject
    private Logger logger;

    public boolean canAddAnnotation(String target, String userName) {
        return this.authorization.hasAccess(Right.COMMENT, this.getUserReference(userName), this.getDocumentReference(target));
    }

    public boolean canEditAnnotation(String annotationId, String target, String userName) {
        try {
            boolean hasEditRight = this.authorization.hasAccess(Right.EDIT, this.getUserReference(userName), this.getDocumentReference(target));
            if (hasEditRight) {
                return true;
            }
            Annotation ann = this.annotationsStorageService.getAnnotation(target, annotationId);
            return ann != null && ann.getAuthor().equals(userName);
        }
        catch (Exception e) {
            this.logException(e, target, userName);
            return false;
        }
    }

    public boolean canViewAnnotatedTarget(String target, String userName) {
        return this.canViewAnnotations(target, userName);
    }

    public boolean canViewAnnotations(String target, String userName) {
        return this.authorization.hasAccess(Right.VIEW, this.getUserReference(userName), this.getDocumentReference(target));
    }

    private EntityReference getDocumentReference(String target) {
        EntityReference ref = this.referenceResolver.resolve(target, EntityType.DOCUMENT);
        return ref.extractReference(EntityType.DOCUMENT);
    }

    private DocumentReference getUserReference(String username) {
        return this.userAndGroupReferenceResolver.resolve((Object)username, new Object[0]);
    }

    private void logException(Exception e, String target, String user) {
        this.logger.warn("Couldn't get access rights for the target [{}] for user [{}]", new Object[]{target, user, e});
    }
}

