/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.maintainer.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.maintainer.AnnotationMaintainer;
import org.xwiki.annotation.maintainer.MaintainerServiceException;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="document-content-annotation-updater")
@Singleton
public class DocumentContentAnnotationUpdateListener
implements EventListener {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private AnnotationMaintainer maintainer;
    @Inject
    private Logger logger;
    private volatile boolean isUpdating;
    private final List<Event> eventsList = new ArrayList<DocumentUpdatedEvent>(Arrays.asList(new DocumentUpdatedEvent()));

    public List<Event> getEvents() {
        return this.eventsList;
    }

    public String getName() {
        return "DocumentContentAnnotationUpdateListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        DocumentModelBridge currentDocument = (DocumentModelBridge)source;
        DocumentModelBridge previousDocument = currentDocument.getOriginalDocument();
        if (!this.isUpdating && !previousDocument.getContent().equals(currentDocument.getContent())) {
            this.isUpdating = true;
            String content = currentDocument.getContent();
            String previousContent = previousDocument.getContent();
            EntityReference docReference = new EntityReference(currentDocument.getPageName(), EntityType.DOCUMENT, new EntityReference(currentDocument.getSpaceName(), EntityType.SPACE, new EntityReference(currentDocument.getWikiName(), EntityType.WIKI)));
            try {
                this.maintainer.updateAnnotations((String)this.serializer.serialize(docReference, new Object[0]), previousContent, content);
            }
            catch (MaintainerServiceException e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
            this.isUpdating = false;
        }
    }
}

