/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.maintainer.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;
import org.xwiki.annotation.maintainer.DiffService;
import org.xwiki.annotation.maintainer.XDelta;
import org.xwiki.annotation.maintainer.internal.ChunksXDelta;
import org.xwiki.component.annotation.Component;

@Component(hints={"default", "character"})
public class CharacterDiffService
implements DiffService {
    @Override
    public Collection<XDelta> getDifferences(String previous, String current) {
        ArrayList<XDelta> deltas = new ArrayList<XDelta>();
        ArrayList<Character> previousContent = new ArrayList<Character>();
        for (int i = 0; i < previous.length(); ++i) {
            previousContent.add(Character.valueOf(previous.charAt(i)));
        }
        ArrayList<Character> currentContent = new ArrayList<Character>();
        for (int i = 0; i < current.length(); ++i) {
            currentContent.add(Character.valueOf(current.charAt(i)));
        }
        Diff diff = new Diff(previousContent, currentContent);
        for (Difference it : diff.diff()) {
            XDelta delta = this.getDelta(previous, current, it);
            if (delta == null) continue;
            deltas.add(delta);
        }
        return deltas;
    }

    private XDelta getDelta(String previous, String current, Difference diff) {
        String original = "";
        String modified = "";
        if (diff.getDeletedStart() == -1 || diff.getAddedStart() == -1) {
            return null;
        }
        int position = diff.getDeletedStart();
        if (diff.getDeletedEnd() != -1) {
            original = previous.substring(diff.getDeletedStart(), diff.getDeletedEnd() + 1);
        }
        if (diff.getAddedEnd() != -1) {
            modified = current.substring(diff.getAddedStart(), diff.getAddedEnd() + 1);
        }
        return new ChunksXDelta(position, original, modified);
    }
}

