/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.maintainer;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.content.AlteredContent;
import org.xwiki.annotation.content.ContentAlterer;
import org.xwiki.annotation.io.IOService;
import org.xwiki.annotation.io.IOTargetService;
import org.xwiki.annotation.maintainer.AnnotationMaintainer;
import org.xwiki.annotation.maintainer.AnnotationState;
import org.xwiki.annotation.maintainer.DiffService;
import org.xwiki.annotation.maintainer.MaintainerServiceException;
import org.xwiki.annotation.maintainer.XDelta;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.transformation.TransformationManager;

public abstract class AbstractAnnotationMaintainer
implements AnnotationMaintainer {
    @Inject
    protected IOService ioService;
    @Inject
    protected IOTargetService ioContentService;
    @Inject
    @Named(value="whitespace")
    protected ContentAlterer spaceStripperContentAlterer;
    @Inject
    protected ComponentManager componentManager;

    @Override
    public void updateAnnotations(String target, String previousContent, String currentContent) throws MaintainerServiceException {
        try {
            Collection annotations = this.ioService.getAnnotations(target);
            if (annotations.size() == 0) {
                return;
            }
            ArrayList<Annotation> toUpdate = new ArrayList<Annotation>();
            String syntaxId = this.ioContentService.getSourceSyntax(target);
            String renderedPreviousContent = this.renderPlainText(previousContent, syntaxId);
            String renderedCurrentContent = this.renderPlainText(currentContent, syntaxId);
            Collection<XDelta> differences = this.getDiffService().getDifferences(renderedPreviousContent, renderedCurrentContent);
            if (differences.size() > 0) {
                AlteredContent spacelessRenderedPreviousContent = this.spaceStripperContentAlterer.alter((CharSequence)renderedPreviousContent);
                for (Annotation annotation : annotations) {
                    boolean wasUpdated = this.recomputeProperties(annotation, differences, renderedPreviousContent, spacelessRenderedPreviousContent, renderedCurrentContent);
                    if (!wasUpdated) continue;
                    toUpdate.add(annotation);
                }
            }
            this.ioService.updateAnnotations(target, toUpdate);
        }
        catch (Exception e) {
            throw new MaintainerServiceException("An exception occurred while updating annotations for content at " + target, e);
        }
    }

    private String renderPlainText(String content, String syntaxId) throws Exception {
        PrintRenderer renderer = (PrintRenderer)this.componentManager.getInstance(PrintRenderer.class, "normalizer-plain/1.0");
        Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
        XDOM xdom = parser.parse((Reader)new StringReader(content));
        SyntaxFactory syntaxFactory = (SyntaxFactory)this.componentManager.getInstance(SyntaxFactory.class);
        Syntax sourceSyntax = syntaxFactory.createSyntaxFromIdString(syntaxId);
        TransformationManager transformationManager = (TransformationManager)this.componentManager.getInstance(TransformationManager.class);
        transformationManager.performTransformations(xdom, sourceSyntax);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.setPrinter((WikiPrinter)printer);
        xdom.traverse((Listener)renderer);
        return printer.toString();
    }

    protected boolean recomputeProperties(Annotation annotation, Collection<XDelta> differences, String renderedPreviousContent, AlteredContent spacelessPreviousContent, String renderedCurrentContent) {
        boolean updated = false;
        if (annotation.getState().equals((Object)AnnotationState.ALTERED)) {
            return updated;
        }
        String spacelessLeftContext = StringUtils.isEmpty((CharSequence)annotation.getSelectionLeftContext()) ? "" : this.spaceStripperContentAlterer.alter((CharSequence)annotation.getSelectionLeftContext()).getContent().toString();
        String spacelessRightContext = StringUtils.isEmpty((CharSequence)annotation.getSelectionRightContext()) ? "" : this.spaceStripperContentAlterer.alter((CharSequence)annotation.getSelectionRightContext()).getContent().toString();
        String spacelessSelection = StringUtils.isEmpty((CharSequence)annotation.getSelection()) ? "" : this.spaceStripperContentAlterer.alter((CharSequence)annotation.getSelection()).getContent().toString();
        String spacelessContext = spacelessLeftContext + spacelessSelection + spacelessRightContext;
        int selectionIndex = spacelessLeftContext.length();
        int lastSelectionIndex = selectionIndex + spacelessSelection.length() - 1;
        int cStart = spacelessPreviousContent.getContent().toString().indexOf(spacelessContext);
        if (spacelessContext.length() == 0 || cStart < 0) {
            return updated;
        }
        int cEnd = cStart + spacelessContext.length();
        int sStart = cStart + selectionIndex;
        int sEnd = cStart + lastSelectionIndex;
        cStart = spacelessPreviousContent.getInitialOffset(cStart);
        cEnd = spacelessPreviousContent.getInitialOffset(cEnd - 1) + 1;
        sStart = spacelessPreviousContent.getInitialOffset(sStart);
        sEnd = spacelessPreviousContent.getInitialOffset(sEnd) + 1;
        AnnotationState initialState = annotation.getState();
        int alteredCStart = cStart;
        int alteredSLength = sEnd - sStart;
        for (XDelta diff : differences) {
            int dStart = diff.getOffset();
            int dEnd = diff.getOffset() + diff.getOriginal().length();
            if (dEnd <= sStart) {
                alteredCStart += diff.getSignedDelta();
            }
            if (dEnd > sStart && dStart >= sStart && dStart < sEnd && dEnd <= sEnd) {
                alteredSLength += diff.getSignedDelta();
                annotation.setState(AnnotationState.UPDATED);
                updated = true;
            }
            if (dStart <= sStart && dEnd >= sEnd) {
                annotation.setState(AnnotationState.ALTERED);
                updated = true;
                break;
            }
            if (dStart < sStart && dEnd > sStart && dEnd <= sEnd) {
                alteredCStart += diff.getSignedDelta();
                annotation.setState(AnnotationState.UPDATED);
                updated = true;
            }
            if (dStart >= sEnd || dEnd <= sEnd) continue;
            annotation.setState(AnnotationState.UPDATED);
            updated = true;
        }
        if (annotation.getState() != AnnotationState.ALTERED) {
            int cLeftSize = sStart - cStart;
            int cRightSize = cEnd - sEnd;
            if (annotation.getState() == AnnotationState.UPDATED && initialState == AnnotationState.SAFE) {
                annotation.setOriginalSelection(annotation.getSelection());
                updated = true;
            }
            String originalLeftContext = annotation.getSelectionLeftContext();
            String originalSelection = annotation.getSelection();
            String originalRightContext = annotation.getSelectionRightContext();
            String contextLeft = renderedCurrentContent.substring(alteredCStart, alteredCStart + cLeftSize);
            String selection = renderedCurrentContent.substring(alteredCStart + cLeftSize, alteredCStart + cLeftSize + alteredSLength);
            String contextRight = renderedCurrentContent.substring(alteredCStart + cLeftSize + alteredSLength, alteredCStart + cLeftSize + alteredSLength + cRightSize);
            annotation.setSelection(selection, contextLeft, contextRight);
            this.ensureUnique(annotation, renderedCurrentContent, alteredCStart, cLeftSize, alteredSLength, cRightSize);
            updated = updated || !selection.equals(originalSelection) || !contextLeft.equals(originalLeftContext) || !contextRight.equals(originalRightContext);
        }
        return updated;
    }

    private void ensureUnique(Annotation annotation, String content, int cStart, int cLeftSize, int sLength, int cRightSize) {
        List<Integer> occurrences = this.getOccurrences(content, annotation.getSelectionInContext(), cStart);
        if (occurrences.size() == 0) {
            return;
        }
        boolean isUnique = false;
        int cLength = cLeftSize + sLength + cRightSize;
        int expansionLeft = 0;
        int expansionRight = 0;
        char charLeft = content.charAt(cStart - expansionLeft);
        char charRight = content.charAt(cStart + cLength + expansionRight - 1);
        block0: while (!isUnique) {
            boolean updated = false;
            if (cStart - expansionLeft - 1 > 0) {
                charLeft = content.charAt(cStart - ++expansionLeft);
                updated = true;
            }
            if (cStart + cLength + expansionRight + 1 <= content.length()) {
                charRight = content.charAt(cStart + cLength + ++expansionRight - 1);
                updated = true;
            }
            if (!updated) break;
            if (charLeft == ' ' || charRight == ' ') continue;
            isUnique = true;
            for (int occurence : occurrences) {
                Character occurenceCharLeft = this.getSafeCharacter(content, occurence - expansionLeft);
                Character occurenceCharRight = this.getSafeCharacter(content, occurence + cLength + expansionRight - 1);
                if (occurenceCharLeft == null || occurenceCharLeft.charValue() != charLeft || occurenceCharRight == null || occurenceCharRight.charValue() != charRight) continue;
                isUnique = false;
                continue block0;
            }
        }
        if (isUnique) {
            expansionLeft += this.toNextWord(content, cStart - expansionLeft, true);
            expansionRight += this.toNextWord(content, cStart + cLength + expansionRight, false);
            String contextLeft = content.substring(cStart - expansionLeft, cStart + cLeftSize);
            String selection = content.substring(cStart + cLeftSize, cStart + cLeftSize + sLength);
            String contextRight = content.substring(cStart + cLeftSize + sLength, cStart + cLength + expansionRight);
            annotation.setSelection(selection, contextLeft, contextRight);
        }
    }

    private List<Integer> getOccurrences(String subject, String pattern, int exclude) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int lastIndex = subject.indexOf(pattern);
        while (lastIndex != -1) {
            if (lastIndex != exclude) {
                indexes.add(lastIndex);
            }
            lastIndex = subject.indexOf(pattern, lastIndex + 1);
        }
        return indexes;
    }

    private int toNextWord(String subject, int position, boolean toLeft) {
        boolean isSpaceOrEnd;
        int expansion = 1;
        boolean bl = toLeft ? position - expansion < 0 || subject.charAt(position - expansion) == ' ' : (isSpaceOrEnd = position + expansion > subject.length() || subject.charAt(position + expansion - 1) == ' ');
        while (!isSpaceOrEnd) {
            isSpaceOrEnd = toLeft ? position - expansion < 0 || subject.charAt(position - expansion) == ' ' : position + ++expansion > subject.length() || subject.charAt(position + expansion - 1) == ' ';
        }
        return expansion - 1;
    }

    private Character getSafeCharacter(String content, int position) {
        if (position >= 0 && position < content.length()) {
            return Character.valueOf(content.charAt(position));
        }
        return null;
    }

    public abstract DiffService getDiffService();
}

