/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal.representations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.xwiki.annotation.rest.internal.representations.AbstractFormUrlEncodedAnnotationUpdateRequestReader;
import org.xwiki.annotation.rest.model.jaxb.AnnotationAddRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.ObjectFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="org.xwiki.annotation.rest.internal.representations.FormUrlEncodedAnnotationAddRequestReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedAnnotationAddRequestReader
extends AbstractFormUrlEncodedAnnotationUpdateRequestReader<AnnotationAddRequest> {
    private static final String SELECTION_CONTEXT_FIELD_NAME = "selectionContext";
    private static final String SELECTION_OFFSET_FIELD_NAME = "selectionOffset";
    private static final String SELECTION_FIELD_NAME = "selection";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(AnnotationAddRequest.class);
    }

    @Override
    protected AnnotationAddRequest getReadObjectInstance(ObjectFactory factory) {
        AnnotationAddRequest addRequest = factory.createAnnotationAddRequest();
        addRequest.setRequest(new AnnotationRequest.Request());
        addRequest.setFilter(factory.createAnnotationFieldCollection());
        addRequest.setAnnotation(factory.createAnnotationFieldCollection());
        return addRequest;
    }

    @Override
    protected boolean saveField(AnnotationAddRequest annotationAddRequest, String key, String value, ObjectFactory objectFactory) {
        if (SELECTION_FIELD_NAME.equals(key)) {
            annotationAddRequest.setSelection(value);
            return true;
        }
        if (SELECTION_CONTEXT_FIELD_NAME.equals(key)) {
            annotationAddRequest.setSelectionContext(value);
            return true;
        }
        if (SELECTION_OFFSET_FIELD_NAME.equals(key)) {
            int offset = 0;
            try {
                offset = Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            annotationAddRequest.setSelectionOffset(offset);
            return true;
        }
        return super.saveField(annotationAddRequest, key, value, objectFactory);
    }
}

