/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.AnnotationService;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rights.AnnotationRightService;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="annotations")
@Singleton
public class AnnotationScriptService
implements ScriptService {
    @Inject
    private AnnotationService annotationService;
    @Inject
    private AnnotationRightService rightsService;
    @Inject
    private Execution execution;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public boolean addAnnotation(String target, String selection, String selectionContext, int offset, String author, Map<String, Object> metadata) {
        if (!this.rightsService.canAddAnnotation(target, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return false;
        }
        try {
            this.annotationService.addAnnotation(target, selection, selectionContext, offset, author, metadata);
            return true;
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return false;
        }
    }

    public String getAnnotatedHTML(String sourceReference) {
        if (!this.rightsService.canViewAnnotatedTarget(sourceReference, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return null;
        }
        try {
            return this.annotationService.getAnnotatedHTML(sourceReference);
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return null;
        }
    }

    public String getAnnotatedRenderedContent(String sourceReference, String sourceSyntax, String outputSyntax, Collection<Annotation> annotations) {
        if (!this.rightsService.canViewAnnotatedTarget(sourceReference, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return null;
        }
        try {
            return this.annotationService.getAnnotatedRenderedContent(sourceReference, sourceSyntax, outputSyntax, annotations);
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return null;
        }
    }

    public Annotation getAnnotation(String target, String id) {
        if (!this.rightsService.canViewAnnotations(target, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return null;
        }
        try {
            return this.annotationService.getAnnotation(target, id);
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return null;
        }
    }

    public Collection<Annotation> getAnnotations(String target) {
        if (!this.rightsService.canViewAnnotations(target, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return null;
        }
        try {
            return this.annotationService.getAnnotations(target);
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return null;
        }
    }

    public Collection<Annotation> getValidAnnotations(String target) {
        if (!this.rightsService.canViewAnnotations(target, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return null;
        }
        try {
            return this.annotationService.getValidAnnotations(target);
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return null;
        }
    }

    public boolean removeAnnotation(String target, String annotationID) {
        if (!this.rightsService.canEditAnnotation(annotationID, target, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return false;
        }
        try {
            this.annotationService.removeAnnotation(target, annotationID);
            return true;
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return false;
        }
    }

    public boolean updateAnnotation(String target, Annotation annotation) {
        if (!this.rightsService.canEditAnnotation(annotation.getId(), target, this.getCurrentUser())) {
            this.setAccessExceptionOnContext();
            return false;
        }
        try {
            this.annotationService.updateAnnotation(target, annotation);
            return true;
        }
        catch (AnnotationServiceException e) {
            this.setExceptionOnContext((Exception)((Object)e));
            return false;
        }
    }

    public boolean canEditAnnotation(String annotationId, String wiki, String space, String page) {
        DocumentReference docRef = new DocumentReference(wiki, space, page);
        String serializedDocRef = (String)this.serializer.serialize((EntityReference)docRef, new Object[0]);
        return this.rightsService.canEditAnnotation(annotationId, serializedDocRef, this.getCurrentUser());
    }

    public boolean canAddAnnotation(String wiki, String space, String page) {
        DocumentReference docRef = new DocumentReference(wiki, space, page);
        String serializedDocRef = (String)this.serializer.serialize((EntityReference)docRef, new Object[0]);
        return this.rightsService.canAddAnnotation(serializedDocRef, this.getCurrentUser());
    }

    private String getCurrentUser() {
        return this.getXWikiContext().getUser();
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private void setExceptionOnContext(Exception exception) {
        this.getXWikiContext().put((Object)"lastexception", (Object)exception);
    }

    private void setAccessExceptionOnContext() {
        this.setExceptionOnContext((Exception)new XWikiException(9, 9001, "You are not allowed to perform this action"));
    }
}

