/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="applicationmanager")
public class ApplicationManagerListener
implements EventListener {
    private static final String XWIKIPREFERENCES = "XWiki.XWikiPreferences";
    private static final List<Event> EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentUpdatedEvent());
            this.add(new DocumentCreatedEvent());
        }
    };
    @Inject
    private Logger logger;
    private ApplicationManager applicationManager;
    private ApplicationManagerMessageTool messageTool;

    private ApplicationManagerMessageTool getApplicationManagerMessageTool(XWikiContext xcontext) {
        if (this.messageTool == null) {
            this.messageTool = ApplicationManagerMessageTool.getDefault(xcontext);
        }
        return this.messageTool;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "applicationmanager";
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        XWikiContext xcontext = (XWikiContext)data;
        try {
            if (XWikiApplicationClass.isApplication(document)) {
                this.getApplicationManager(xcontext).updateApplicationsTranslation(document, xcontext);
            } else if (document.getFullName().equals(XWIKIPREFERENCES)) {
                this.getApplicationManager(xcontext).updateAllApplicationTranslation(xcontext);
            }
        }
        catch (XWikiException e) {
            this.logger.error(this.getApplicationManagerMessageTool(xcontext).get("applicationmanager.plugin.log.autoupdatetranslations", document.getFullName()), (Throwable)e);
        }
    }

    private ApplicationManager getApplicationManager(XWikiContext xcontext) {
        if (this.applicationManager == null) {
            this.applicationManager = new ApplicationManager(this.getApplicationManagerMessageTool(xcontext));
        }
        return this.applicationManager;
    }
}

