/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPlugin;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationPackager;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;

public class ApplicationManagerPluginApi
extends PluginApi<ApplicationManagerPlugin> {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationManagerPluginApi.class);
    private XWikiExceptionApi defaultException;
    private ApplicationManager applicationManager;
    private ApplicationPackager applicationPackager;
    private ContextualLocalizationManager localizationManager;

    public ApplicationManagerPluginApi(ApplicationManagerPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
        this.defaultException = new XWikiExceptionApi((XWikiException)((Object)ApplicationManagerException.getDefaultException()), context);
        this.applicationManager = new ApplicationManager();
        this.applicationPackager = new ApplicationPackager();
        this.localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);
    }

    public XWikiExceptionApi getDefaultException() {
        return this.defaultException;
    }

    @Deprecated
    public XWikiMessageTool getMessageTool() {
        return ApplicationManagerMessageTool.getDefault(this.context);
    }

    public void logError(String errorMessage, XWikiException e) {
        LOGGER.error(errorMessage, (Throwable)e);
        this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi(e, this.context));
    }

    public XWikiApplication createApplicationDocument() throws XWikiException {
        return (XWikiApplication)XWikiApplicationClass.getInstance(this.context).newXObjectDocument(this.context);
    }

    public int createApplication(XWikiApplication appXObjectDocument, boolean failOnExist) throws XWikiException {
        int returncode = -1;
        try {
            this.applicationManager.createApplication(appXObjectDocument, failOnExist, this.localizationManager.getTranslationPlain("applicationmanager.plugin.comment.createapplication", new Object[]{appXObjectDocument.toString()}), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.createapplication", new Object[]{appXObjectDocument.toString()}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteApplication(String appName) throws XWikiException {
        int returncode = -1;
        try {
            this.applicationManager.deleteApplication(appName, this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.deleteapplication", new Object[]{appName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public List<XWikiApplication> getApplicationDocumentList() throws XWikiException {
        List<XWikiApplication> listDocument = Collections.emptyList();
        try {
            listDocument = this.applicationManager.getApplicationList(this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.getallapplications", new Object[0]), (XWikiException)((Object)e));
        }
        return listDocument;
    }

    public XWikiApplication getApplicationDocument(String appName) throws XWikiException {
        XWikiApplication app = null;
        try {
            app = this.applicationManager.getApplication(appName, this.context, true);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.getapplication", new Object[]{appName}), (XWikiException)((Object)e));
        }
        return app;
    }

    public int exportApplicationXAR(String appName) throws XWikiException, IOException {
        return this.exportApplicationXAR(appName, true, false);
    }

    public int exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory) throws XWikiException, IOException {
        int returncode = -1;
        try {
            this.applicationPackager.exportApplicationXAR(appName, recurse, withDocHistory, this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.exportapplication", new Object[]{appName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int importApplication(String packageName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            this.applicationPackager.importApplication(this.context.getDoc(), packageName, this.localizationManager.getTranslationPlain("applicationmanager.plugin.comment.importapplication", new Object[]{packageName}), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.importapplication", new Object[]{packageName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int reloadApplication(String appName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            XWikiApplication app = this.applicationManager.getApplication(appName, this.context, true);
            this.applicationManager.reloadApplication(app, this.localizationManager.getTranslationPlain("applicationmanager.plugin.comment.reloadapplication", new Object[]{app.getAppName()}), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.reloadapplication", new Object[]{appName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int reloadAllApplications() throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        try {
            this.applicationManager.reloadAllApplications(this.localizationManager.getTranslationPlain("applicationmanager.plugin.comment.reloadallapplications", new Object[0]), this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.realoadallapplications", new Object[0]), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public XWikiApplication getRootApplication() throws XWikiException {
        XWikiApplication app = null;
        try {
            app = this.applicationManager.getRootApplication(this.context);
        }
        catch (ApplicationManagerException e) {
            this.logError(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.getrootapplication", new Object[0]), (XWikiException)((Object)e));
        }
        return app;
    }
}

