/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPlugin;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="applicationmanager")
@Singleton
public class ApplicationManagerScriptService
implements ScriptService {
    private static final String PLUGINAPI_KEY = "applicationmanagerapi";
    private static final String PLUGIN_ID = "applicationmanager";
    @Inject
    private Execution execution;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private ApplicationManagerPlugin plugin;

    private ApplicationManagerPlugin getPlugin(XWikiContext xcontext) {
        this.plugin = (ApplicationManagerPlugin)xcontext.getWiki().getPlugin(PLUGIN_ID, xcontext);
        if (this.plugin == null) {
            this.plugin = new ApplicationManagerPlugin(PLUGIN_ID, ApplicationManagerPlugin.class.getName(), xcontext);
            this.plugin.init(xcontext);
        }
        return this.plugin;
    }

    private ApplicationManagerPluginApi getAPI() {
        ExecutionContext econtext = this.execution.getContext();
        ApplicationManagerPluginApi api = (ApplicationManagerPluginApi)((Object)econtext.getProperty(PLUGINAPI_KEY));
        if (api == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            api = (ApplicationManagerPluginApi)this.getPlugin(xcontext).getPluginApi((XWikiPluginInterface)this.plugin, xcontext);
            econtext.setProperty(PLUGINAPI_KEY, (Object)api);
        }
        return api;
    }

    public XWikiExceptionApi getDefaultException() {
        return this.getAPI().getDefaultException();
    }

    @Deprecated
    public XWikiMessageTool getMessageTool() {
        return ApplicationManagerMessageTool.getDefault((XWikiContext)this.xcontextProvider.get());
    }

    public XWikiApplication createApplicationDocument() throws XWikiException {
        return this.getAPI().createApplicationDocument();
    }

    public int createApplication(XWikiApplication appXObjectDocument, boolean failOnExist) throws XWikiException {
        return this.getAPI().createApplication(appXObjectDocument, failOnExist);
    }

    public int deleteApplication(String appName) throws XWikiException {
        return this.getAPI().deleteApplication(appName);
    }

    public List<XWikiApplication> getApplicationDocumentList() throws XWikiException {
        return this.getAPI().getApplicationDocumentList();
    }

    public XWikiApplication getApplicationDocument(String appName) throws XWikiException {
        return this.getAPI().getApplicationDocument(appName);
    }

    public int exportApplicationXAR(String appName) throws XWikiException, IOException {
        return this.getAPI().exportApplicationXAR(appName);
    }

    public int exportApplicationXAR(String appName, boolean recurse, boolean withDocHistory) throws XWikiException, IOException {
        return this.getAPI().exportApplicationXAR(appName, recurse, withDocHistory);
    }

    public int importApplication(String packageName) throws XWikiException {
        return this.getAPI().importApplication(packageName);
    }

    public int reloadApplication(String appName) throws XWikiException {
        return this.getAPI().reloadApplication(appName);
    }

    public int reloadAllApplications() throws XWikiException {
        return this.getAPI().reloadAllApplications();
    }

    public XWikiApplication getRootApplication() throws XWikiException {
        return this.getAPI().getRootApplication();
    }

    public ApplicationManagerPlugin getInternalPlugin() {
        return (ApplicationManagerPlugin)this.getAPI().getInternalPlugin();
    }

    public boolean hasProgrammingRights() {
        return this.getAPI().hasProgrammingRights();
    }

    public boolean hasAdminRights() {
        return this.getAPI().hasAdminRights();
    }

    public boolean hasWikiAdminRights() {
        return this.getAPI().hasWikiAdminRights();
    }

    public boolean hasAccessLevel(String right, String docname) throws XWikiException {
        return this.getAPI().hasAccessLevel(right, docname);
    }
}

