/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.appwithinminutes.test.po.ApplicationClassEditPage;
import org.xwiki.appwithinminutes.test.po.ApplicationHomePage;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.wysiwyg.EditorElement;
import org.xwiki.test.ui.po.editor.wysiwyg.RichTextAreaElement;

public class ApplicationHomeEditPage
extends InlinePage {
    @FindBy(xpath="//a[. = 'Previous Step']")
    private WebElement previousStepButton;
    @FindBy(id="wizard-next")
    private WebElement finishButton;
    @FindBy(name="xaction_save")
    private WebElement saveButton;
    @FindBy(name="xaction_saveandcontinue")
    private WebElement saveAndContinueButton;
    @FindBy(id="availableColumns")
    private WebElement availableColumns;
    @FindBy(xpath="//div[@class = 'columnPicker']/input[@type = 'image' and @alt = 'Add']")
    private WebElement addColumnButton;
    @FindBy(id="applicationIcon")
    private WebElement applicationIconInput;
    private final EditorElement descriptionEditor = new EditorElement("AppWithinMinutes.LiveTableClass_0_description");

    public ApplicationClassEditPage clickPreviousStep() {
        this.previousStepButton.click();
        return new ApplicationClassEditPage();
    }

    public ApplicationHomePage clickFinish() {
        this.finishButton.click();
        return new ApplicationHomePage();
    }

    public <T extends ViewPage> T clickSaveAndView() {
        this.saveButton.click();
        return this.createViewPage();
    }

    public void clickSaveAndContinue() {
        this.saveAndContinueButton.click();
    }

    protected <T extends ViewPage> T createViewPage() {
        return (T)((Object)new ApplicationHomePage());
    }

    public void setDescription(String description) {
        this.descriptionEditor.waitToLoad();
        RichTextAreaElement descriptionTextArea = this.descriptionEditor.getRichTextArea();
        descriptionTextArea.clear();
        descriptionTextArea.sendKeys(new CharSequence[]{description});
    }

    public void setIcon(String icon) {
        this.applicationIconInput.clear();
        this.applicationIconInput.sendKeys(new CharSequence[]{icon});
    }

    public String getIcon() {
        return this.applicationIconInput.getAttribute("value");
    }

    public void addLiveTableColumn(String columnLabel) {
        Select select = new Select(this.availableColumns);
        select.selectByVisibleText(columnLabel);
        this.addColumnButton.click();
    }

    public void removeLiveTableColumn(String columnLabel) {
        WebElement column = this.getLiveTableColumn(columnLabel);
        new Actions(this.getDriver()).moveToElement(column).perform();
        column.findElement(By.className((String)"delete")).click();
    }

    public void moveLiveTableColumnBefore(String columnToMove, String beforeColumn) {
        new Actions(this.getDriver()).clickAndHold(this.getLiveTableColumn(columnToMove)).moveToElement(this.getLiveTableColumn(beforeColumn), -3, 0).release().perform();
    }

    private WebElement getLiveTableColumn(String columnLabel) {
        String escapedColumnLabel = columnLabel.replace("\\", "\\\\").replace("'", "\\'");
        String xpath = "//ul[@class = 'hList']/li[starts-with(., '" + escapedColumnLabel + "')]";
        return ApplicationHomeEditPage.getUtil().findElementWithoutWaiting(this.getDriver(), this.getForm(), By.xpath((String)xpath));
    }

    public boolean hasLiveTableColumn(String columnLabel) {
        String escapedColumnLabel = columnLabel.replace("\\", "\\\\").replace("'", "\\'");
        String xpath = "//ul[@class = 'hList']/li[starts-with(., '" + escapedColumnLabel + "')]";
        return ApplicationHomeEditPage.getUtil().findElementsWithoutWaiting(this.getDriver(), this.getForm(), By.xpath((String)xpath)).size() > 0;
    }

    public boolean isLiveTableColumnDeprecated(String columnLabel) {
        return "deprecated".equals(this.getLiveTableColumn(columnLabel).getAttribute("class"));
    }

    public void removeAllDeprecatedLiveTableColumns(boolean yes) {
        WebElement warningMessage = ApplicationHomeEditPage.getUtil().findElementWithoutWaiting(this.getDriver(), this.getForm(), By.className((String)"warningmessage"));
        ApplicationHomeEditPage.getUtil().findElementWithoutWaiting(this.getDriver(), warningMessage, By.linkText((String)(yes ? "Yes" : "No"))).click();
    }

    public boolean isDeprecatedLiveTableColumnsWarningDisplayed() {
        List warnings = ApplicationHomeEditPage.getUtil().findElementsWithoutWaiting(this.getDriver(), this.getForm(), By.className((String)"warningmessage"));
        return warnings.size() == 1 && ((WebElement)warnings.get(0)).isDisplayed();
    }

    public ApplicationHomeEditPage waitUntilPageIsLoaded() {
        this.descriptionEditor.waitToLoad();
        return this;
    }
}

